% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weir.R
\name{flow_weir}
\alias{flow_weir}
\title{Flow Over Weir Crest}
\usage{
flow_weir(B, h, w = Inf, mu = 0.73)
}
\arguments{
\item{B}{Width of the weir [m].}

\item{h}{Height difference between the upstream water level and the
weir crest [m].}

\item{w}{Height of the weir crest (upstream) [m]. If w = Inf, the
upstream velocity is considered 0.}

\item{mu}{Discharge coefficient [-]. Default is 0.73.}
}
\value{
A list with the following components:
\describe{
  \item{Q}{Flow over the weir [m3/s].}
  \item{v}{Flow velocity [m/s].}
}
}
\description{
Calculates the flow over a weir crest based on upstream
  water level.
}
\examples{
flow_weir(B = 3, h = 1.2)
flow_weir(B = 3, h = 1.2, w = 1)
}
