% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{concentration_data_Linakis2020}
\alias{concentration_data_Linakis2020}
\title{Concentration data involved in Linakis 2020 vignette analysis.}
\format{
A data.frame containing 2142 rows and 16 columns.
}
\source{
Matt Linakis
}
\usage{
concentration_data_Linakis2020
}
\description{
These rat and human TK concentration vs. time (CvT) data are drawn from
the CvTdb (Sayre et el., 2020). Concentrations have all been converted to
the units of uM. All data are from inhalation studies.
}
\details{
Abbreviations used for sampling matrix:
BL : blood
EEB : end-exhaled breath
MEB : mixed exhaled breath
VBL : venous blood
ABL : arterial blood
EB : unspecified exhaled breath sample (assumed to be EEB)
PL: plasma
+W with work/exercise

\tabular{ll}{
\strong{Column Name} \tab \strong{Description} \cr
 PREFERRED_NAME        \tab Substance preferred name \cr                      
 DTXSID     \tab Identifier for CompTox Chemical Dashboard \cr
 CASRN  \tab Chemical abstracts service registration number\cr
 AVERAGE_MASS  \tab Substance molecular weight g/mol \cr
  DOSE DOSE_U   \tab Inhalation exposure concentration in parts per million \cr  
 EXP_LENGTH   \tab Duration of inhalation exposur \cr
  TIME  \tab  Measurment time \cr          
 TIME_U   \tab  Time units for all times reported \cr 
 CONC_SPECIES  \tab Species for study \cr 
 SAMPLING_MATRIX   \tab Matrix analyzed \cr 
 SOURCE_CVT   \tab Data source identifier within CvTdb \cr 
 ORIG_CONC_U   \tab Original reported units for concentration \cr 
 CONCENTRATION   \tab Analyte concentration in uM units\cr 
}
}
\references{
\insertRef{linakis2020development}{httk}
\insertRef{sayre2020database}{httk}
}
\author{
Matt Linakis
}
\keyword{data}
