% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_yes_no.R
\name{tar_yes_no}
\alias{tar_yes_no}
\title{Convert "yes" and "no" to 1 and 0}
\usage{
tar_yes_no(x)
}
\arguments{
\item{x}{A vector containing elements to be converted. Elements should be
character strings potentially including "yes" and "no".}
}
\value{
A numeric vector where "yes" is replaced with 1, "no" with 0, and
  other values with NA.
}
\description{
This function takes a vector and converts all instances of "yes" to 1, "no" to 0,
and leaves other values as NA. It's useful for converting categorical "yes"/"no"
responses into a numeric format that can be used in statistical analysis.
}
\examples{
test_vector <- c("yes", "no", "maybe", "yes", "no")
tar_yes_no(test_vector)
}
