% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_split.R
\name{pulse_split}
\alias{pulse_split}
\title{(\verb{STEP 2}) Split \code{pulse_data} across sequential time windows}
\usage{
pulse_split(
  pulse_data,
  window_width_secs = 30,
  window_shift_secs = 60,
  min_data_points = 0.8,
  subset = 0,
  subset_seed = NULL,
  subset_reindex = FALSE,
  msg = TRUE
)
}
\arguments{
\item{pulse_data}{the output from a call to \code{\link[=pulse_read]{pulse_read()}}.}

\item{window_width_secs}{numeric, in seconds, defaults to \code{30}; the width of the time windows over which heart rate frequency will be computed.}

\item{window_shift_secs}{numeric, in seconds, defaults to \code{60}; by how much each subsequent window is shifted from the preceding one.}

\item{min_data_points}{numeric, defaults to \code{0.8}; decimal from 0 to 1, used as a threshold to discard incomplete windows where data is missing (e.g., if the sampling frequency is \code{20} and \code{window_width_secs = 30}, each window should include \code{600} data points, and so if \code{min_data_points = 0.8}, windows with less than \code{600 * 0.8 = 480} data points will be rejected).}

\item{subset}{numerical, defaults to \code{0}; the number of time windows to keep from the entire dataset (or the number of entries to reject if set to a negative value); smaller subsets make the entire processing quicker and facilitate the execution of trial runs to optimize parameter selection before processing the entire dataset.}

\item{subset_seed}{numerical, defaults to \code{NULL}; only used if \code{subset} is different from \code{0}; \code{subset_seed} controls the seed used when extracting a subset of the available data; if set to \code{NULL}, a random seed is selected, resulting in rows being selected randomly; alternativelly, the user can set a specific seed in order to always select the same rows (important when the goal is to compare the impact of different parameter combinations using the exact same data points).}

\item{subset_reindex}{logical, defaults to \code{FALSE}; only used if \code{subset} is different from \code{0}; after extracting a subset of the available data, should rows be re-indexed (i.e., \code{.$i} made fully sequential); re-indexed rows make using \code{pulse_plot_raw()} easier, but row identity doesn't match anymore with row identity before subsetting.}

\item{msg}{logical, defaults to \code{TRUE}; should non-crucial messages (but not errors) be shown (mostly for use from within the wrapper function \code{PULSE()}, where it is set to \code{FALSE} to avoid the repetition of identical messages)}
}
\value{
A tibble with three columns. Column $\code{i} stores the order of each time window. Column $\code{smoothed} is a logical vector flagging smoothed data (at this point defaulting to \code{FALSE}, but later if \code{\link{pulse_optimize}} is used, values can change to \code{TRUE}. Column $\code{data} is a list with all the valid time windows (i.e., complying with \code{min_data_points}), each window being a subset of \code{pulse_data} (a tibble with at least 2 columns (time + one or more channels) containing PULSE data with timestamps within that time window)
}
\description{
\itemize{
\item \verb{step 1} -- \code{\link[=pulse_read]{pulse_read()}}
\item \strong{\verb{-->>} step 2 -- \code{\link[=pulse_split]{pulse_split()}} \verb{<<--}}
\item \verb{step 3} -- \code{\link[=pulse_optimize]{pulse_optimize()}}
\item \verb{step 4} -- \code{\link[=pulse_heart]{pulse_heart()}}
\item \verb{step 5} -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}
\item \verb{step 6} -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}}
}

After all raw PULSE data has been imported, the dataset must be split across sequential time windows.

\code{pulse_split()} takes the output from a call to \code{pulse_read()} and splits data across user-defined time windows. The output of \code{pulse_split()} can be immediately passed to \code{pulse_heart()}, or first optimized with \code{pulse_optimize()} and only then passed to \code{pulse_heart()} (highly recommended).
}
\section{Window \code{width} and \code{shift}}{

A good starting point for \code{window_width_secs} is to set it to between \code{30} and \code{60} seconds.

As a rule of thumb, use lower values for data collected from animals with naturally faster heart rates and/or that have been subjected to treatments conducive to fast heart rates still (e.g., thermal performance ramps). In such cases, lower values will result in higher temporal resolution, which may be crucial if experimental conditions are changing rapidly. Conversely, experiments using animals with naturally slower heart rates and/or subjected to treatments that may cause heart rates to stabilize or even slow (e.g., control or cold treatments) may require the use of higher values for \code{window_width_secs}, as the resulting windows should encompass no less than 5-7 heartbeat cycles.

As for \code{window_shift_secs}, set it to a value:
\itemize{
\item smaller than \code{window_width_secs} if overlap between windows is desired (not usually recommended) (if \code{window_width_secs = 30} and \code{window_shift_secs = 15}, the first 3 windows will go from \verb{[0, 30)}, \verb{[15, 45)} and \verb{[30, 60)})
\item equal to \code{window_width_secs} to process all data available (if \code{window_width_secs = 30} and \code{window_shift_secs = 30}, the first 3 windows will go from \verb{[0, 30)}, \verb{[30, 60)} and \verb{[60, 90)})
\item larger than \code{window_width_secs} to skip data (ideal for speeding up the processing of large datasets) (if \code{window_width_secs = 30} and \code{window_shift_secs = 60}, the first 3 windows will go from \verb{[0, 30)}, \verb{[60, 90)} and \verb{[120, 150)})
}

In addition, also consider that lower values for the \code{window_...} parameters may lead to oversampling and a cascade of statistical issues, the resolution of which may end up negating any advantage gained.
}

\section{Handling gaps in the dataset}{

\code{min_data_points} shouldn't be set too low, otherwise only nearly empty windows will be rejected.
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
## End prepare data ----

pulse_split(pulse_data_sub)
}
\seealso{
\itemize{
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
