% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_optimize.R
\name{pulse_interpolate}
\alias{pulse_interpolate}
\title{Increase the number of data points in PULSE data through interpolation}
\usage{
pulse_interpolate(split_window, interpolation_freq = 40, multi)
}
\arguments{
\item{split_window}{one element of the \code{pulse_data_split} list() (which is the output from \code{\link[=pulse_split]{pulse_split()}}).}

\item{interpolation_freq}{numeric, defautls to \code{40}; value expressing the frequency (in Hz) to which PULSE data should be interpolated. Can be set to \code{0} (zero) or any value equal or greater than \code{40} (the default). If set to zero, no interpolation is performed.}

\item{multi}{logical; was the data  generated by a multi-channel system (\code{TRUE}) or a one-channel system (\code{FALSE})?}
}
\value{
The same PULSE tibble supplied in \code{split_window}, but now with data interpolated to \code{interpolation_freq} (i.e., with more data points)
}
\description{
The performance of the algorithm employed in the downstream function \code{pulse_heart()} for the detection of heart beat wave crests depends significantly on there being a sufficient number of data points around each crest. \code{pulse_interpolate()} reshapes the data non-destructively and improves the likelihood of \code{pulse_heart()} successfully estimating the inherent heartbeat rates.
\itemize{
\item \code{INTERPOLATION} is highly recommended because tests on real data have shown that a frequency of at least 40 Hz is crucial to ensure wave crests can be discerned even when the underlying heartbeat rate is high (i.e., at rates above 2-3 Hz). Since the PULSE multi-channel system is not designed to capture data at such high rates (partially because it would generate files unnecessarily large), \code{pulse_interpolate()} is used instead to artificially increase the temporal resolution of the data by linearly interpolating to the target frequency. It is important to note that this process DOES NOT ALTER the shape of the heart beat wave, it just introduces intermediary data points. Also, the only downside to using very high values for \code{interpolation_freq} is the proportional increase in computing time and size of the outputs together with minimal improvements in the performance of \code{pulse_heart()} - but no artefacts are expected.
}
}
\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
pulse_data_split <- pulse_split(pulse_data_sub)
## End prepare data ----

# Interpolate data to 40 Hz
pulse_interpolate(pulse_data_split$data[[1]], 40, multi = pulse_data$multi)
}
\seealso{
\itemize{
\item \code{\link[=approx]{approx()}} is used for the linear interpolation of PULSE data
\item \code{\link[=pulse_optimize]{pulse_optimize()}} is a wrapper function that executes \code{pulse_interpolate} and \code{\link[=pulse_smooth]{pulse_smooth()}} sequentially
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
