% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{heaping_indices}
\alias{heaping_indices}
\title{Calculate All Heaping Indices}
\usage{
heaping_indices(x, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A named list with all heaping indices:
  \describe{
    \item{whipple_standard}{Standard Whipple index (100 = no heaping)}
    \item{whipple_modified}{Modified Whipple index (0 = no heaping)}
    \item{myers}{Myers' blended index (0 = no heaping)}
    \item{bachi}{Bachi's index (0 = no heaping)}
    \item{spoorenberg}{Total Modified Whipple index (0 = no heaping)}
    \item{noumbissi_0}{Noumbissi's index for digit 0 (1 = no heaping)}
    \item{noumbissi_5}{Noumbissi's index for digit 5 (1 = no heaping)}
  }
}
\description{
This function calculates all available heaping indices for a given age
vector, providing a comprehensive assessment of data quality.
}
\details{
Convenience function to calculate multiple heaping indices at once.
}
\examples{
set.seed(42)
# Uniform ages (no heaping)
age_uniform <- sample(20:70, 10000, replace = TRUE)
heaping_indices(age_uniform)

# Heaped ages
age_heaped <- sample(seq(20, 70, by = 5), 5000, replace = TRUE)
heaping_indices(age_heaped)

}
\seealso{
Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
