% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_bar.R
\name{gt_plt_bar}
\alias{gt_plt_bar}
\title{Add bar plots into rows of a \code{gt} table}
\usage{
gt_plt_bar(
  gt_object,
  column = NULL,
  color = "purple",
  ...,
  keep_column = FALSE,
  width = 40,
  scale_type = "none",
  text_color = "white"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{A single column wherein the bar plot should replace existing data.}

\item{color}{A character representing the color for the bar, defaults to purple. Accepts a named color (eg \code{'purple'}) or a hex color.}

\item{...}{Additional arguments passed to \code{scales::label_number()} or \code{scales::label_percent()}, depending on what was specified in \code{scale_type}}

\item{keep_column}{\code{TRUE}/\code{FALSE} logical indicating if you want to keep a copy of the "plotted" column as raw values next to the plot itself..}

\item{width}{An integer indicating the width of the plot in pixels.}

\item{scale_type}{A string indicating additional text formatting and the addition of numeric labels to the plotted bars if not \code{'none'}. If \code{'none'}, no numbers will be added to the bar, but if \code{"number"} or \code{"percent"} are used, then the numbers in the plotted column will be added as a bar-label and formatted according to \code{scales::label_percent()} or \code{scales::label_number()}.}

\item{text_color}{A string indicating the color of text if \code{scale_type} is used. Defaults to \code{"white"}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_bar} function takes an existing \code{gt_tbl} object and
adds horizontal barplots via \code{ggplot2}. Note that values are plotted on a
shared x-axis, and a vertical black bar is added at x = zero. To add labels
to each of the of the bars, set \code{scale_type} to either \code{'percent'} or \verb{'number}'.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
gt_plt_bar_tab <- mtcars \%>\%
  head() \%>\%
  gt() \%>\%
  gt_plt_bar(column = mpg, keep_column = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\figure{gt_plt_bar.png}{options: width=500}}
}

\section{Function ID}{

3-4
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
