% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls.R
\name{gsl_nls_control}
\alias{gsl_nls_control}
\title{Tunable Nonlinear Least Squares iteration parameters}
\usage{
gsl_nls_control(
  maxiter = 100,
  scale = "more",
  solver = "qr",
  fdtype = "forward",
  factor_up = 2,
  factor_down = 3,
  avmax = 0.75,
  h_df = sqrt(.Machine$double.eps),
  h_fvv = 0.02,
  xtol = sqrt(.Machine$double.eps),
  ftol = sqrt(.Machine$double.eps),
  gtol = sqrt(.Machine$double.eps),
  mstart_n = 30,
  mstart_p = 5,
  mstart_q = mstart_n\%/\%10,
  mstart_r = 4,
  mstart_s = 2,
  mstart_tol = 0.25,
  mstart_maxiter = 10,
  mstart_maxstart = 250,
  mstart_minsp = 1,
  irls_maxiter = 50,
  irls_xtol = .Machine$double.eps^0.25,
  ...
)
}
\arguments{
\item{maxiter}{positive integer, termination occurs when the number of iterations reaches \code{maxiter}.}

\item{scale}{character, scaling method or damping strategy determining the diagonal scaling matrix D. The following options
are supported:
\itemize{
\item \code{"more"} Moré rescaling (default). This method makes the problem scale-invariant and has
been proven effective on a large class of problems.
\item \code{"levenberg"} Levenberg rescaling. This method has also proven effective on a large class of problems,
but is not scale-invariant. It may perform better for problems susceptible to \emph{parameter evaporation} (parameters going to infinity).
\item \code{"marquardt"} Marquardt rescaling. This method is scale-invariant, but it is generally
considered inferior to both the Levenberg and Moré strategies.
}}

\item{solver}{character, method used to solve the linear least squares system resulting as a subproblem in each iteration.
For large-scale problems fitted with \code{\link{gsl_nls_large}}, the Cholesky solver (\code{"cholesky"}) is always selected
and this parameter is not used. For least squares problems fitted with \code{\link{gsl_nls}} the following choices are supported:
\itemize{
\item \code{"qr"} QR decomposition of the Jacobian (default). This method will produce reliable solutions in cases
where the Jacobian is rank deficient or near-singular but does require more operations than the Cholesky method.
\item \code{"cholesky"} Cholesky decomposition of the Jacobian. This method is faster than the QR approach, however
it is susceptible to numerical instabilities if the Jacobian matrix is rank deficient or near-singular.
\item \code{"svd"} SVD decomposition of the Jacobian. This method will produce the most reliable solutions for
ill-conditioned Jacobians but is also the slowest.
}}

\item{fdtype}{character, method used to numerically approximate the Jacobian and/or second-order derivatives
when geodesic acceleration is used. Either \code{"forward"} for forward finite differencing or \code{"center"}
for centered finite differencing. For least squares problems solved with \code{\link{gsl_nls_large}}, numerical
approximation of the Jacobian matrix is not available and this parameter is only used to numerically approximate
the second-order derivatives (if geodesic acceleration is used).}

\item{factor_up}{numeric factor by which to increase the trust region radius when a search step is accepted.
Too large values may destabilize the search, too small values slow down the search, defaults to 2.}

\item{factor_down}{numeric factor by which to decrease the trust region radius when a search step is rejected.
Too large values may destabilize the search, too small values slow down the search, defaults to 3.}

\item{avmax}{numeric value, the ratio of the acceleration term to the velocity term when using geodesic acceleration to
solve the nonlinear least squares problem. Any steps with a ratio larger than \code{avmax} are rejected, defaults to 0.75.
For problems which experience difficulty converging, this threshold could be lowered.}

\item{h_df}{numeric value, the step size for approximating the Jacobian matrix with finite differences, defaults to \code{sqrt(.Machine$double.eps)}.}

\item{h_fvv}{numeric value, the step size for approximating the second directional derivative when geodesic acceleration
is used to solve the nonlinear least squares problem, defaults to 0.02. This is only used if no analytic second
directional derivative (\code{fvv}) is specified in \code{\link{gsl_nls}} or \code{\link{gsl_nls_large}}.}

\item{xtol}{numeric value, termination occurs when the relative change in parameters between iterations is \code{<= xtol}.
A general guideline for selecting the step tolerance is to choose \code{xtol = 10^(-d)} where \code{d} is the number of accurate
decimal digits desired in the parameters, defaults to \code{sqrt(.Machine$double.eps)}.}

\item{ftol}{numeric value, termination occurs when the relative change in sum of squared residuals between iterations is \code{<= ftol},
defaults to \code{sqrt(.Machine$double.eps)}.}

\item{gtol}{numeric value, termination occurs when the relative size of the gradient of the sum of squared residuals is \code{<= gtol},
indicating a local minimum, defaults to \code{sqrt(.Machine$double.eps)}}

\item{mstart_n}{positive integer, number of quasi-random points drawn in each major iteration, parameter \code{N} in Hickernell and Yuan (1997). Default is 30.}

\item{mstart_p}{positive integer, number of iterations of inexpensive local search to concentrate the sample, parameter \code{p} in Hickernell and Yuan (1997). Default is 5.}

\item{mstart_q}{positive integer, number of points retained in the concentrated sample, parameter \code{q} in Hickernell and Yuan (1997). Default is \code{mstart_n \%/\% 10}..}

\item{mstart_r}{positive integer, scaling factor of number of stationary points determining when the multi-start algorithm terminates, parameter \code{r} in Hickernell and Yuan (1997). Default is 4.
If the starting ranges for one or more parameters are unbounded and updated dynamically, \code{mstart_r} is multiplied by a factor 10 to avoid early termination.}

\item{mstart_s}{positive integer, minimum number of iterations a point needs to be retained before starting an efficient local search, parameter \code{s} in Hickernell and Yuan (1997). Default is 2.}

\item{mstart_tol}{numeric value, multiplicative tolerance \code{(1 + mstart_tol)} used as criterion to start an efficient local search (epsilon in Algorithm 2.1, Hickernell and Yuan (1997)).}

\item{mstart_maxiter}{positive integer, maximum number of iterations in the efficient local search algorithm (Algorithm B, Hickernell and Yuan (1997)), defaults to 10.}

\item{mstart_maxstart}{positive integer, minimum number of major iterations (Algorithm 2.1, Hickernell and Yuan (1997)) before the multi-start algorithm terminates, defaults to 250.}

\item{mstart_minsp}{positive integer, minimum number of detected stationary points before the multi-start algorithm terminates, defaults to 1.}

\item{irls_maxiter}{positive integer, maximum number of IRLS iterations, defaults to 50. Only used in case of a non-default loss function (\code{loss != "default"}) optimized by IRLS.}

\item{irls_xtol}{numeric value, termination of the IRLS procedure occurs when the relative change in parameters between IRLS iterations is \code{<= irls_xtol}, defaults to \code{.Machine$double.eps^(1/4)}.
Only used in case of a non-default loss function (\code{loss != "default"}) optimized by IRLS.}

\item{...}{any additional arguments (currently not used).}
}
\value{
A \code{list} with exactly twenty-three components:
\itemize{
\item maxiter
\item scale
\item solver
\item fdtype
\item factor_up
\item factor_down
\item avmax
\item h_df
\item h_fvv
\item xtol
\item ftol
\item gtol
\item mstart_n
\item mstart_p
\item mstart_q
\item mstart_r
\item mstart_s
\item mstart_tol
\item mstart_maxiter
\item mstart_maxstart
\item mstart_minsp
\item irls_maxiter
\item irls_xtol
}
with meanings as explained under 'Arguments'.
}
\description{
Allow the user to tune the characteristics of the \code{\link{gsl_nls}} and \code{\link{gsl_nls_large}}
nonlinear least squares algorithms.
}
\note{
\code{ftol} is disabled in some versions of the GSL library.
}
\examples{
## default tuning parameters
gsl_nls_control()
}
\references{
M. Galassi et al., \emph{GNU Scientific Library Reference Manual (3rd Ed.)}, ISBN 0954612078.

Hickernell, F.J. and Yuan, Y. (1997) \emph{“A simple multistart algorithm for global optimization”}, OR Transactions, Vol. 1 (2).
}
\seealso{
\code{\link[stats]{nls.control}}

\url{https://www.gnu.org/software/gsl/doc/html/nls.html#tunable-parameters}
}
