% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Z.Var.Estimator.Sequential.TTFE.R
\name{TwoSample.Z.Var.Estimator.Sequential.TTFE}
\alias{TwoSample.Z.Var.Estimator.Sequential.TTFE}
\title{Function to calculate the two-sample time-to-first-event (TTFE) statistics and variances across multiple calendar times.}
\usage{
TwoSample.Z.Var.Estimator.Sequential.TTFE(data, tau = NULL, calendars)
}
\arguments{
\item{data}{A data frame containing two-sample composite endpoint data, typically generated by \code{TwoSample.generate.sequential()}.}

\item{tau}{Optional upper bound for the event-time horizon. This argument is
currently not used and is included for interface consistency with other
sequential estimators in the package.}

\item{calendars}{A numeric vector of calendar times at which interim analyses are
conducted. Each value is treated as an administrative censoring time.}
}
\value{
A list with components:
\itemize{
\item \code{Z.stats}: A numeric vector of log-rank Z-statistics evaluated at each
  calendar analysis time.
\item \code{vars}: A numeric vector of estimated variances of the Z-statistics at
  each analysis time.
  \item \code{total.ns}: A numeric vector giving the total number of subjects
  contributing data at each calendar analysis time.
}
}
\description{
Computes sequential Z-statistics and their corresponding variance estimates for a
two-sample time-to-first-event (TTFE) analysis at a set of prespecified calendar
analysis times. At each calendar time, administrative censoring is applied, event
times are converted from the calendar scale to the event-time scale, and a standard
log-rank test is performed using only the first observed event per subject.
}
