% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_gs_nbinom.R
\name{sim_gs_nbinom}
\alias{sim_gs_nbinom}
\title{Simulate group sequential clinical trial for negative binomial outcomes}
\usage{
sim_gs_nbinom(
  n_sims,
  enroll_rate,
  fail_rate,
  dropout_rate = NULL,
  max_followup,
  event_gap = 0,
  analysis_times = NULL,
  n_target = NULL,
  design = NULL,
  data_cut = cut_data_by_date,
  cuts = NULL
)
}
\arguments{
\item{n_sims}{Number of simulations to run.}

\item{enroll_rate}{Enrollment rates (data frame with \code{rate} and \code{duration}).}

\item{fail_rate}{Failure rates (data frame with \code{treatment}, \code{rate}, \code{dispersion}).}

\item{dropout_rate}{Dropout rates (data frame with \code{treatment}, \code{rate}, \code{duration}).}

\item{max_followup}{Maximum follow-up time.}

\item{event_gap}{Event gap duration.}

\item{analysis_times}{Vector of calendar times for interim and final analyses.
Optional if \code{cuts} is provided.}

\item{n_target}{Total sample size to enroll (optional, if not defined by \code{enroll_rate}).}

\item{design}{An object of class \code{gsNB} or \code{sample_size_nbinom_result}.
Used to extract planning parameters (\code{lambda1}, \code{lambda2}, \code{ratio}) for blinded
information estimation.}

\item{data_cut}{Function to cut data for analysis. Defaults to \code{\link[=cut_data_by_date]{cut_data_by_date()}}.
The function must accept \code{sim_data}, \code{cut_date}, and \code{event_gap} as arguments.}

\item{cuts}{A list of cutting criteria for each analysis. Each element of the list
should be a list of arguments for \code{\link[=get_cut_date]{get_cut_date()}} (e.g., \code{planned_calendar},
\code{target_events}, \code{target_info}). If provided, \code{analysis_times} is ignored
(or used as a fallback if \code{planned_calendar} is missing in a cut).}
}
\value{
A data frame containing simulation results for each analysis of each trial.
Columns include:
\describe{
\item{sim}{Simulation ID}
\item{analysis}{Analysis index}
\item{analysis_time}{Calendar time of analysis}
\item{n_enrolled}{Number of subjects enrolled}
\item{n_ctrl}{Number of subjects in control group}
\item{n_exp}{Number of subjects in experimental group}
\item{events_total}{Total events observed}
\item{events_ctrl}{Events in control group}
\item{events_exp}{Events in experimental group}
\item{exposure_at_risk_ctrl}{Exposure at risk in control group (adjusted for event gaps)}
\item{exposure_at_risk_exp}{Exposure at risk in experimental group (adjusted for event gaps)}
\item{exposure_total_ctrl}{Total exposure in control group (calendar follow-up)}
\item{exposure_total_exp}{Total exposure in experimental group (calendar follow-up)}
\item{z_stat}{Z-statistic from the Wald test (positive favors experimental if rate ratio < 1)}
\item{estimate}{Estimated log rate ratio from the model}
\item{se}{Standard error of the estimate}
\item{method_used}{Method used for inference ("nb" or "poisson")}
\item{dispersion}{Estimated dispersion parameter from the model}
\item{blinded_info}{Estimated blinded statistical information (ML)}
\item{unblinded_info}{Observed unblinded statistical information (ML)}
\item{info_unblinded_ml}{Observed unblinded statistical information (ML)}
\item{info_blinded_ml}{Estimated blinded statistical information (ML)}
\item{info_unblinded_mom}{Observed unblinded statistical information (Method of Moments)}
\item{info_blinded_mom}{Estimated blinded statistical information (Method of Moments)}
}
}
\description{
Simulates multiple replicates of a group sequential clinical trial with negative
binomial outcomes, performing interim analyses at specified calendar times.
}
\examples{
set.seed(123)
enroll_rate <- data.frame(rate = 10, duration = 3)
fail_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.6, 0.4),
  dispersion = 0.2
)
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.05, 0.05),
  duration = c(6, 6)
)
design <- sample_size_nbinom(
  lambda1 = 0.6, lambda2 = 0.4, dispersion = 0.2, power = 0.8,
  accrual_rate = enroll_rate$rate, accrual_duration = enroll_rate$duration,
  trial_duration = 6
)
cuts <- list(
  list(planned_calendar = 2),
  list(planned_calendar = 4)
)
sim_results <- sim_gs_nbinom(
  n_sims = 2,
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  dropout_rate = dropout_rate,
  max_followup = 4,
  n_target = 30,
  design = design,
  cuts = cuts
)
head(sim_results)
}
