new_GPPMControl <- function(stanModel) {
  stopifnot(is.logical(stanModel))


  structure(list(
    stanModel = stanModel # generate stanModel Object or not
  ), class = "GPPMControl")
}

#' Define settings for a Gaussian process panel model
#'
#' This function is used to specify the settings of a Gaussian process panel model generated by \code{\link{gppm}}.
#'
#' @param stanModel boolean. Should the corresponding stan model be created? Should only be set to FALSE for testing purposes.
#' Not creating the stan model makes model fitting impossible but saves a lot of time.

#' @return Settings for a Gaussian process panel model in an object of class 'GPPMControl'
#' @seealso \code{\link{gppm}}
#' @export
gppmControl <- function(stanModel = TRUE) {
  new_GPPMControl(stanModel)
}
