% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.glmmTMB}
\alias{predict.glmmTMB}
\title{prediction}
\usage{
\method{predict}{glmmTMB}(
  object,
  newdata = NULL,
  newparams = NULL,
  se.fit = FALSE,
  cov.fit = FALSE,
  re.form = NULL,
  allow.new.levels = NULL,
  type = c("link", "response", "conditional", "zprob", "zlink", "disp", "latent"),
  zitype = NULL,
  na.action = na.pass,
  fast = NULL,
  debug = FALSE,
  aggregate = NULL,
  do.bias.correct = FALSE,
  bias.correct.control = list(sd = TRUE),
  ...
)
}
\arguments{
\item{object}{a \code{glmmTMB} object}

\item{newdata}{new data for prediction}

\item{newparams}{new parameters for prediction}

\item{se.fit}{return the standard errors of the predicted values?}

\item{cov.fit}{return the covariance matrix of the predicted values?}

\item{re.form}{\code{NULL} to specify individual-level predictions; \code{~0} or \code{NA} to specify population-level predictions (i.e., setting all random effects to zero)}

\item{allow.new.levels}{allow previously unobserved levels in random-effects variables? see details.}

\item{type}{Denoting \eqn{mu} as the mean of the conditional distribution and
\code{p} as the zero-inflation probability,
the possible choices are:
\describe{
\item{"link"}{the linear predictor of the conditional model, or
equivalently the conditional mean on the scale of the link function
(this equivalence does not hold for truncated distributions, where
the link-scaled value is not adjusted for the effect of truncation on the mean; to get the corrected value of the conditional mean on the linear predictor
scale, use \code{family(m)$linkfun(predict(m, type = "conditional"))})}
\item{"response"}{expected value; this is \eqn{mu*(1-p)} for zero-inflated models
and \code{mu} otherwise}
\item{"conditional"}{mean of the conditional response; \code{mu} for all models
(i.e., synonymous with \code{"response"} in the absence of zero-inflation}
\item{"zprob"}{the probability of a structural zero (returns 0 for non-zero-inflated models)}
\item{"zlink"}{predicted zero-inflation probability on the scale of
the logit link function (returns \code{-Inf} for non-zero-inflated models)}
\item{"disp"}{dispersion parameter, however it is defined for that particular family (as described in  \code{\link{sigma.glmmTMB}})}
\item{"latent"}{return latent variables}
}}

\item{zitype}{deprecated: formerly used to specify type of zero-inflation probability. Now synonymous with \code{type}}

\item{na.action}{how to handle missing values in \code{newdata} (see \code{\link{na.action}});
the default (\code{na.pass}) is to predict \code{NA}}

\item{fast}{predict without expanding memory (default is TRUE if \code{newdata} and \code{newparams} are NULL and population-level prediction is not being done)}

\item{debug}{(logical) return the \code{TMBStruc} object that will be
used internally for debugging?}

\item{aggregate}{(optional factor vector) sum the elements with matching factor levels}

\item{do.bias.correct}{(logical) should aggregated predictions use Taylor expanded estimate of nonlinear contribution of random effects (see details)}

\item{bias.correct.control}{a list sent to TMB's function \code{sdreport()}. See documentation there.}

\item{\dots}{unused - for method compatibility}
}
\description{
prediction
}
\details{
\itemize{
\item To compute population-level predictions for a given grouping variable (i.e., setting all random effects for that grouping variable to zero), set the grouping variable values to \code{NA}. Finer-scale control of conditioning (e.g. allowing variation among groups in intercepts but not slopes when predicting from a random-slopes model) is not currently possible.
\item Prediction of new random effect levels is possible as long as the model specification (fixed effects and parameters) is kept constant.
However, to ensure intentional usage, a warning is triggered if \code{allow.new.levels} is \code{NULL} (the default) and \code{re.form} is not NA, or if \code{allow.new.levels} is explicitly set to \code{TRUE}.
\item Prediction using "data-dependent bases" (variables whose scaling or transformation depends on the original data, e.g. \code{\link{poly}}, \code{\link[splines]{ns}}, or \code{\link{poly}}) should work properly; however, users are advised to check results extra-carefully when using such variables. Models with different versions of the same data-dependent basis type in different components (e.g. \code{formula= y ~ poly(x,3), dispformula= ~poly(x,2)}) will probably \emph{not} produce correct predictions.
\item Bias corrected predictions are based on the method described in Thorson J.T. & Kristensen (2016). These should be checked carefully by the user and are not extensively tested.
}
}
\examples{
data(sleepstudy,package="lme4")
g0 <- glmmTMB(Reaction~Days+(Days|Subject),sleepstudy)
predict(g0, sleepstudy)
## Predict new Subject
nd <- sleepstudy[1,]
nd$Subject <- "new"
predict(g0, newdata=nd, allow.new.levels=TRUE)
## population-level prediction
nd_pop <- data.frame(Days=unique(sleepstudy$Days),
                     Subject=NA)
predict(g0, newdata=nd_pop)
## return latent variables (BLUPs/conditional modes/etc. ) with standard errors
##  (actually conditional standard deviations)
predict(g0, type = "latent", se.fit = TRUE)
}
\references{
Thorson J.T. & Kristensen K. (2016) Implementing a generic method for bias correction in statistical models using random effects, with spatial and population dynamics examples. \emph{Fish. Res.} 175, 66-74.
}
