% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{match_snfg_style}
\alias{match_snfg_style}
\title{Match SNFG Style to Graph Nodes}
\usage{
match_snfg_style(graph)
}
\arguments{
\item{graph}{An `igraph` object.}
}
\value{
An `igraph` object with additional vertex attributes: `snfg_shape` (numeric starshape) and `snfg_fill` (color).
}
\description{
Maps glycan node labels to SNFG shapes and colors.
}
\examples{
s <- "Neu5Ac(a2-3)Gal(b1-4)GlcNAc(b1-2)Man(a1-3)Man(b1-4)GlcNAc(b1-4)GlcNAc"
g <- read_glycan(s)
g <- match_snfg_style(g)
}
