% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{validated_fonts}
\alias{validated_fonts}
\title{List of validated default fonts}
\usage{
validated_fonts(fonts = list())
}
\arguments{
\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the defaults
from \code{\link[gdtools:font_set_liberation]{gdtools::font_set_liberation()}} are used.}
}
\value{
a named list of validated font family names
}
\description{
Validates and possibly modifies the fonts to be used as default
value in a graphic according to the fonts available on the machine. It
processes elements named "sans", "serif", "mono" and "symbol".

Default font resolution is delegated to \code{\link[gdtools:font_set_liberation]{gdtools::font_set_liberation()}},
which uses Liberation fonts (bundled by 'fontquiver', SIL Open Font
License) for reproducible offline output.
}
\examples{
validated_fonts()
}
\seealso{
\code{\link[=girafe]{girafe()}}, \code{\link[=dsvg]{dsvg()}}

Other functions for font management: 
\code{\link{match_family}()}
}
\concept{functions for font management}
