% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displace.R
\name{with_displacement}
\alias{with_displacement}
\title{Apply a displacement map to a layer}
\usage{
with_displacement(x, x_map, y_map = x_map, x_scale = 1, y_scale = x_scale, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{x_map, y_map}{The displacement maps to use. Can either be a string
identifying a registered filter, or a raster object. The maps will be resized
to match the dimensions of x. Only one channel will be used - see
\link[=Channels]{the docs on channels} for info on how to set them.}

\item{x_scale, y_scale}{How much displacement should a maximal channel value
correspond to? If a numeric it will be interpreted as pixel dimensions. If a
unit object it will be converted to pixel dimension when rendered.}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter displaces the pixels based on the colour values of another layer
or raster object. As such it can be used to distort the content of the layer.
}
\examples{
library(ggplot2)
ggplot() +
  as_reference(
    geom_polygon(aes(c(0, 1, 1), c(0, 0, 1)), colour = NA, fill = 'magenta' ),
    id = "displace_map"
  ) +
  with_displacement(
    geom_text(aes(0.5, 0.5, label = 'Displacements!'), size = 10),
    x_map = ch_red("displace_map"),
    y_map = ch_blue("displace_map"),
    x_scale = unit(0.025, 'npc'),
    y_scale = unit(0.025, 'npc')
  )

}
