library(testthat)
library(ggdiagram)

test_that("style", {
  s1 <- ob_style()
  expect_no_error(s1@polar_just <- ob_point(1, 2))
  expect_no_error(s1@polar_just <- degree(45))
  expect_no_error(s1@polar_just <- 45)
  expect_no_error(ob_style(linetype = NA))
  expect_no_error(ob_style(linewidth = NA))
  expect_no_error(ob_style(polar_just = degree(45)))
  expect_no_error(ob_style(polar_just = 4))
  expect_no_error(ob_style(polar_just = 4:5))
  expect_no_error(ob_style(polar_just = ob_polar(theta = degree(45), r = 3)))
  expect_no_error(ob_style(arrow_fins = arrowheadr::arrow_head_deltoid()))
  expect_no_error(ob_style(arrow_mid = arrowheadr::arrow_head_deltoid()))
  expect_no_error(ob_style(angle = degree(45)))
  expect_no_error(capture.output(print(ob_style(color = "red")), file = nullfile()))
  expect_identical(
    ob_style(color = "red") + ob_style(fill = "blue"),
    ob_style(color = "red", fill = "blue")
  )
  expect_no_error(`+`(ob_style(color = "red"), ob_style(fill = "blue")))
  expect_identical(`+`(ob_style(color = "red"), S7::class_missing), ob_style(color = "red"))
  expect_identical(`+`(S7::class_missing, ob_style(color = "red")), ob_style(color = "red"))
  expect_identical(`+`(ob_style(color = "red"), 3), ob_style(color = "red"))
  expect_identical(`+`(3, ob_style(color = "red")), ob_style(color = "red"))
  expect_identical(get_tibble(ob_style(color = "red")), tibble::tibble(color = "red"))
  expect_identical(ob_style(color = c("red", "blue"))[2], ob_style(color = "blue"))
})
