% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcs.R
\name{ob_arc}
\alias{ob_arc}
\alias{ob_wedge}
\alias{ob_circular_segment}
\title{ob_arc class}
\usage{
ob_arc(
  center = ob_point(0, 0),
  radius = 1,
  start = 0,
  end = 0,
  label = character(0),
  label_sloped = FALSE,
  start_point = S7::class_missing,
  end_point = S7::class_missing,
  n = 360,
  type = "arc",
  alpha = numeric(0),
  arrow_head = list(),
  arrow_fins = list(),
  arrowhead_length = numeric(0),
  length_head = numeric(0),
  length_fins = numeric(0),
  color = character(0),
  fill = character(0),
  lineend = numeric(0),
  linejoin = numeric(0),
  linewidth = numeric(0),
  linewidth_fins = numeric(0),
  linewidth_head = numeric(0),
  linetype = numeric(0),
  resect = numeric(0),
  resect_fins = numeric(0),
  resect_head = numeric(0),
  stroke_color = character(0),
  stroke_width = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)

ob_wedge(
  center = ob_point(0, 0),
  radius = 1,
  start = 0,
  end = 0,
  label = character(0),
  label_sloped = FALSE,
  start_point = S7::class_missing,
  end_point = S7::class_missing,
  n = 360,
  type = "wedge",
  alpha = numeric(0),
  arrow_head = list(),
  arrow_fins = list(),
  arrowhead_length = numeric(0),
  length_head = numeric(0),
  length_fins = numeric(0),
  color = NA,
  fill = "black",
  lineend = numeric(0),
  linejoin = numeric(0),
  linewidth = numeric(0),
  linewidth_fins = numeric(0),
  linewidth_head = numeric(0),
  linetype = numeric(0),
  resect = numeric(0),
  resect_fins = numeric(0),
  resect_head = numeric(0),
  stroke_color = character(0),
  stroke_width = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)

ob_circular_segment(
  center = ob_point(0, 0),
  radius = 1,
  start = 0,
  end = 0,
  label = character(0),
  label_sloped = FALSE,
  start_point = S7::class_missing,
  end_point = S7::class_missing,
  n = 360,
  type = "segment",
  alpha = numeric(0),
  arrow_head = list(),
  arrow_fins = list(),
  arrowhead_length = numeric(0),
  length_head = numeric(0),
  length_fins = numeric(0),
  color = NA,
  fill = "black",
  lineend = numeric(0),
  linejoin = numeric(0),
  linewidth = numeric(0),
  linewidth_fins = numeric(0),
  linewidth_head = numeric(0),
  linetype = numeric(0),
  resect = numeric(0),
  resect_fins = numeric(0),
  resect_head = numeric(0),
  stroke_color = character(0),
  stroke_width = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)
}
\arguments{
\item{center}{point at center of the arc (default = \code{ob_point(0,0)})}

\item{radius}{distance between center and edge arc (default = 1)}

\item{start}{start angle. Can be numeric (degrees), \link{degree}, \link{radian}, \link{turn}, or named direction (e.g., "northwest", "east", "below", "left"). Defaults to 0.}

\item{end}{end angle Can be numeric (degrees), \link{degree}, \link{radian}, \link{turn}, or named direction (e.g., "northwest", "east", "below", "left"). Defaults to 0.}

\item{label}{A character, angle, or label object}

\item{label_sloped}{If TRUE, label runs along arc.}

\item{start_point}{Specify where arc starts. Overrides \verb{@center}}

\item{end_point}{Specify where arc ends Overrides \verb{@center}}

\item{n}{number of points in arc (default = 360)}

\item{type}{Type of object to drawn. Can be "arc", "wedge", or "segment"}

\item{alpha}{numeric value for alpha transparency}

\item{arrow_head}{A 2-column matrix of polygon points}

\item{arrow_fins}{A 2-column matrix of polygon points}

\item{arrowhead_length}{Determines the size of the arrow ornaments. This parameter becomes the \code{length} parameter in ggarrow functions. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner.}

\item{length_head}{Determines the size of the arrow head. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{length_fins}{Determines the size of the arrow fins. Numeric values set the ornament size relative to the linewidth. A \link[grid:unit]{grid::unit} value sets the ornament size in an absolute manner. From ggarrow.}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linewidth}{Width of lines}

\item{linewidth_fins}{Line width for arrow fins}

\item{linewidth_head}{Line width for arrow fins}

\item{linetype}{type of lines}

\item{resect}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head and fins.}

\item{resect_fins}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow fins}

\item{resect_head}{A numeric(1) denoting millimeters or \link[grid:unit]{grid::unit} to shorten the arrow head.}

\item{stroke_color}{Color of point border line}

\item{stroke_width}{Stroke width in arrows}

\item{style}{an \code{\link{ob_style}} object}

\item{x}{x-coordinate of center point. If specified, overrides x-coordinate of \verb{@center}.}

\item{y}{x-coordinate of center point. If specified, overrides y-coordinate of \verb{@center}.}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style object}
}
\value{
ob_arc object
}
\description{
Create arcs and wedges
}
\section{Slots}{

\describe{
\item{\code{aesthetics}}{A list of information about the arc's aesthetic properties}

\item{\code{angle_at}}{A function that finds the angle of the specified point in relation to the arc's center}

\item{\code{apothem}}{Distance from center to the chord's midpoint}

\item{\code{arc_length}}{Distance along arc from \code{start_point} to \code{end_point}}

\item{\code{auto_label}}{Places a label at the arc's midpoint}

\item{\code{chord}}{\code{\link{ob_segment}} from \code{start_point} to \code{end_point}}

\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{\link[ggarrow:geom_arrow]{ggarrow::geom_arrow}}.}

\item{\code{hatch}}{A function that puts hatch (tally) marks on arcs. Often used to indicate which arcs have the same angle. The \code{k} parameter controls how many hatch marks to display. The \code{height} parameter controls how long the hatch mark segment is. The \code{sep} parameter controls the separation between hatch marks when \code{k > 2}. Additional parameters sent to \code{\link{ob_segment}}.}

\item{\code{length}}{The number of arcs in the arc object}

\item{\code{midpoint}}{A function that selects 1 or more midpoints of the ob_arc. The \code{position} argument can be between 0 and 1. Additional arguments are passed to \code{\link{ob_point}}.}

\item{\code{point_at}}{A function that finds a point on the arc at the specified angle.}

\item{\code{sagitta}}{\code{\link{ob_segment}} from \code{chord} midpoint to \code{\link{ob_arc}} midpoint}

\item{\code{tangent_at}}{A function that finds the tangent line at the specified angle.}

\item{\code{theta}}{interior angle (end - start)}

\item{\code{tibble}}{Gets a \link[tibble:tibble]{tibble::tibble} or data.frame containing parameters and styles used by \code{\link[ggarrow:geom_arrow]{ggarrow::geom_arrow}}.}
}}

\examples{
# 90-degree arc
ggdiagram() +
  ob_arc(
    radius = 6,
    start = degree(0),
    end = degree(90)
 )
}
