% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_slices.R
\name{ggbrain_slices}
\alias{ggbrain_slices}
\title{R6 class for managing slice data for ggbrain plots}
\description{
R6 class for managing slice data for ggbrain plots

R6 class for managing slice data for ggbrain plots
}
\author{
Michael Hallquist
}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{slice_index}}{read-only access to the slice_index containing the slice numbers}

\item{\code{coord_input}}{the input string used to lookup the slices}

\item{\code{coord_label}}{the calculated x, y, or z coordinate of the relevant slice}

\item{\code{slice_number}}{the slice number along the relevant axis of the 3D image matrix}

\item{\code{slice_data}}{a nested list of data.frames where each element contains all data relevant to
that slice and the list elements within are each a given image}

\item{\code{slice_matrix}}{the slice data in matrix form}

\item{\code{slice_labels}}{a data.frame for each slice containing the coordinates of labels available to be drawn}

\item{\code{layer_names}}{a character vector of layer names within each slice}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_slices-new}{\code{ggbrain_slices$new()}}
\item \href{#method-ggbrain_slices-compute_contrasts}{\code{ggbrain_slices$compute_contrasts()}}
\item \href{#method-ggbrain_slices-as_tibble}{\code{ggbrain_slices$as_tibble()}}
\item \href{#method-ggbrain_slices-get_ranges}{\code{ggbrain_slices$get_ranges()}}
\item \href{#method-ggbrain_slices-get_uvals}{\code{ggbrain_slices$get_uvals()}}
\item \href{#method-ggbrain_slices-clone}{\code{ggbrain_slices$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-new}{}}}
\subsection{Method \code{new()}}{
create a ggbrain_slices object based
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$new(slice_df = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slice_df}}{a data.frame generated by ggbrain_images$get_slices()}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If this becomes a user-facing/exported class, we may want a more friendly constructor
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-compute_contrasts"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-compute_contrasts}{}}}
\subsection{Method \code{compute_contrasts()}}{
computes contrasts of the sliced image data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$compute_contrasts(contrast_list = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contrast_list}}{a named list or character vector containing contrasts to be computed.
The names of the list form the contrast names, while the values should be character strings
that use standard R syntax for logical tests, subsetting, and arithmetic}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-as_tibble"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-as_tibble}{}}}
\subsection{Method \code{as_tibble()}}{
convert the slices object into a data.frame with list-columns for slice data elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$as_tibble()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-get_ranges"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-get_ranges}{}}}
\subsection{Method \code{get_ranges()}}{
calculates the numeric ranges of each image/contrast in this object, across all
constituent slices. This is useful for setting scale limits that are shared across panels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$get_ranges(slice_indices = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slice_indices}}{an optional integer vector of slice indices to be used as a subset in the calculation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a tibble keyed by 'layer' with overall low and high values, as well as split by pos/neg
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-get_uvals"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-get_uvals}{}}}
\subsection{Method \code{get_uvals()}}{
returns a data.frame with the unique values for each label layer, across all
constituent slices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$get_uvals(slice_indices = NULL, add_labels = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slice_indices}}{an optional integer vector of slice indices to be used as a subset in the calculation}

\item{\code{add_labels}}{an optional named list indicating the label columns to add to a given layer. The names
of the list specify the layer to which labels are added and the values should be character vectors
specifying the names of columns that serve as labels for the layer. These are always \emph{added} to any
existing label columns for the layer.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{add_labels} is provided here for any categorical columns that were specified inline in the
layer definition using factor or as.factor, such as aes(fill=factor(value)). Otherwise, it's best
to input data with labels in the first place so that labels are described in the data structure itself.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_slices-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_slices-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_slices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
