% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explotation.R, R/geolevel.R
\name{get_level_layer}
\alias{get_level_layer}
\alias{get_level_layer.geodimension}
\alias{get_level_layer.geolevel}
\title{Get level layer}
\usage{
get_level_layer(gd, level_name, geometry, only_key, inherited, add_prefix)

\method{get_level_layer}{geodimension}(
  gd,
  level_name = NULL,
  geometry = NULL,
  only_key = FALSE,
  inherited = FALSE,
  add_prefix = TRUE
)

\method{get_level_layer}{geolevel}(
  gd,
  level_name = NULL,
  geometry = NULL,
  only_key = FALSE,
  inherited = FALSE,
  add_prefix = TRUE
)
}
\arguments{
\item{gd}{A \code{geolevel} or \code{geodimension} object.}

\item{level_name}{A string.}

\item{geometry}{A string.}

\item{only_key}{A boolean.}

\item{inherited}{A boolean.}

\item{add_prefix}{A boolean.}
}
\value{
A \code{sf} object.
}
\description{
Get a geographic layer associated with a level. We can select the geometry
and, using boolean parameters, which attributes are included in the layer's
table: only the attributes that make up the key and, if applied to a geodimension,
inherited attributes to which the prefix of the level where they are defined
can be added.
}
\examples{

layer_us_state <- get_level_layer(gd_us, "state")

state <-
  geolevel(name = "state",
           layer = layer_us_state,
           key = "statefp")

state_ll <- state |>
  get_level_layer("polygon")


county_ll <- gd_us |>
  get_level_layer(level_name = "county",
                  geometry = "polygon",
                  inherited = TRUE)

}
\seealso{
\code{\link{geodimension}}, \code{\link{geolevel}}

Other information gathering functions: 
\code{\link{get_higher_level_names}()},
\code{\link{get_level_data_geo}()},
\code{\link{get_level_data}()},
\code{\link{get_level_geometries}()},
\code{\link{get_level_names}()}
}
\concept{information gathering functions}
