% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costDistance.R
\name{costDistance}
\alias{costDistance}
\alias{costDistance,TransitionLayer,Coords,missing-method}
\alias{costDistance,TransitionLayer,Coords,Coords-method}
\title{Cost distance}
\usage{
costDistance(x, fromCoords, toCoords)
}
\arguments{
\item{x}{object of class \code{TransitionLayer}}

\item{fromCoords}{first set of point locations
(of \code{SpatialPoints}, matrix or numeric class)}

\item{toCoords}{optional, second set of point
locations (of \code{SpatialPoints}, matrix or numeric class)}
}
\value{
distance matrix (S3 class dist or matrix)
}
\description{
Calculate the least-cost distance between points.
}
\details{
Cost units between cells are defined as the reciprocal
 of the values in the transition matrix.

The function uses Dijkstra's algorithm, as implemented in
 the igraph package.

A projection correction is needed for accuracy in the case
 of grid data for a longlat raster (see function geoCorrection).
}
\examples{
library("raster")
# create a new raster and set all its values to unity.
r <- raster(nrows=18, ncols=36)
r <- setValues(r,runif(ncell(r),0,1))

# create a Transition object from the raster
tr <- transition(r,function(x) 1/mean(x),8)

# asymmetric
ncf <- function(x) max(x) - x[1] + x[2]
tr2 <- transition(r,ncf,8, symm=FALSE)

# create two sets of coordinates
sP1 <- cbind(c(65,5,-65),c(55,35,-35))
sP2 <- cbind(c(50,15,-40),c(80,20,-5))

# from and to identical
costDistance(tr,sP1)
costDistance(tr2,sP1)

# from and to different
costDistance(tr,sP1,sP2)
costDistance(tr2,sP1,sP2)

}
\references{
E.W. Dijkstra. 1959. A note on two problems
 in connexion with graphs. Numerische Mathematik 1, 269 - 271.
}
\seealso{
\code{\link{geoCorrection}},
 \code{\link{accCost}},
}
\author{
Jacob van Etten
}
\keyword{spatial}
