% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{inter_corr}
\alias{inter_corr}
\title{Helper function for interpolating cross-sectional metrics over the length of a silhouette}
\usage{
inter_corr(
  ...,
  x = NULL,
  sil,
  indices = NULL,
  default = 1,
  default_k = 2,
  return = "area_corr",
  v = FALSE
)
}
\arguments{
\item{...}{cross-sections between which to interpolate. Each object can be either a single numeric each giving the quantity to be interpolated between, a full output of cscorr() with option return="all", or a character vector giving filenames to use with cscorr().}

\item{x}{indices along silhouette to use as points of interpolation. If NULL, the function will treat indices as indices of the silhouette itself, not x, and attempt to prepend 1 and append sil (or its length) to it, to make the cross-section interpolate toward the default value at the first and last slice.}

\item{sil}{dataframe or vector (output of measuresil()) or single numeric giving the total number of slices of the silhouette for which to interpolate cross-sections}

\item{indices}{subset of x to which the elements in ... pertain, if ... does not have the same total number of elements as x}

\item{default}{default value to fill for elements of x not in indices, if length(x)>length(...)}

\item{default_k}{default superellipse exponent to use for elements of x not in indices, supersedes setting for default if not NULL and return parameter is set to "area_corr"}

\item{return}{which element of the cscorr() output to return in interpolated form (defaults to area_corr, can also be "asp"}

\item{v}{verbosity setting (logical)}
}
\description{
Helper function for interpolating cross-sectional metrics over the length of a silhouette
}
\details{
This is a convenience function and wrapper around approx() and cscorr(), which creates a linear interpolation of cross-section geometry over the entire length of a silhouette. Input can in principle be any numeric value (but, is intended to primarily be cross-sectional geometry defined by "area_corr" and "asp" elements returned via cscorr().
}
\examples{
fdir <- system.file(package="gdi")
cf <- cscorr(file.path(fdir,"exdata","cross_section.png"))
lat <- measuresil(file.path(fdir,"exdata","lat.png"))
inter_corr(cf,x=c(1,1000,2341), sil=lat, indices=2)
}
