% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submit_archive.R
\name{submit_archive}
\alias{submit_archive}
\title{Submit a Darwin Core Archive to the ALA}
\usage{
submit_archive(quiet = FALSE)
}
\arguments{
\item{quiet}{Whether to suppress messages about what is happening.
Default is set to \code{FALSE}; i.e. messages are shown.}
}
\value{
Does not return anything to the workspace; called for the side-effect
of opening a submission form in the users' default browser.
}
\description{
The preferred method for submitting a dataset for publication via the ALA
is to raise an issue on our \href{https://github.com/AtlasOfLivingAustralia/data-publication}{'Data Publication' GitHub Repository},
and attached your archive zip file (constructed using \code{\link[=build_archive]{build_archive()}}) to
that issue. If your dataset is especially large (>100MB), you will need to
post it in a publicly accessible location (such as a GitHub release) and post
the link instead. This function simply opens a new issue in the users'
default browser to enable dataset submission.
}
\details{
The process for accepting data for publication at ALA is not automated;
this function will initiate an evaluation process, and will not result in
your data being instantly visible on the ALA. Nor does submission guarantee
acceptance, as ALA reserves the right to refuse to publish data that reveals
the locations of threatened or at-risk species.

This mechanism is \strong{entirely public}; your data will be visible to others
from the point you put it on this webpage. If your data contains sensitive
information, contact \href{mailto:support@ala.org.au}{support@ala.org.au} to
arrange a different delivery mechanism.
}
\examples{
if(interactive()){
  submit_archive()
}
}
