% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{times_mfd}
\alias{times_mfd}
\alias{*.mfd}
\title{Pointwise product of multivariate functional data (and scalar multiplication)}
\usage{
times_mfd(mfdobj1, mfdobj2)

\method{*}{mfd}(mfdobj1, mfdobj2)
}
\arguments{
\item{mfdobj1, mfdobj2}{Objects of class \code{mfd} defined on the same basis.}
}
\value{
An object of class \code{mfd} whose coefficients are the pointwise product
of the inputs (with recycling if needed). The basis is the common input
basis. The \code{fdnames} are inherited from the input that supplies the
observation indexing after any replication.
}
\description{
Computes the elementwise (pointwise) product of two objects of class \code{mfd},
returning an \code{mfd} on the same basis. If one object contains a single
replication (one observation) and the other contains multiple, the single
replication is recycled across observations before multiplication.
}
\details{
Alternatively, it also compute the product of an \code{mfd} object with a numeric scalar.

Let coefficient arrays have dimensions \eqn{(nbasis, nobs, nvar)}.
The function:
\itemize{
\item requires both inputs to be \code{mfd} objects;
\item requires identical basis systems (checked with \code{identical()});
\item requires the same number of variables;
\item for observations: if both \eqn{nobs_1} and \eqn{nobs_2} are greater
than one, they must be equal; otherwise, the object with
\eqn{nobs = 1} is replicated to match the other.
}

Internally, coefficient arrays are converted to \code{\link[fda]{fd}} objects
and multiplied via \code{\link[fda]{times.fd}}, with \code{basisobj} set to
the common basis so that the result is re-expanded on the same basis.
}
\examples{
# Assuming mfdobj_a and mfdobj_b are 'mfd' objects on the same basis:
# mfdobj_a * mfdobj_b   # elementwise product
# 2 * mfdobj_a          # scalar multiplication
# mfdobj_a * 0.5        # scalar multiplication

}
\seealso{
\code{\link{plus_mfd}}, \code{\link{minus_mfd}},
\code{\link[stats]{nobs}}, \code{\link{nvar}}, \code{\link{nbasis}},
\code{\link[fda]{times.fd}}, \code{\link{mfd}}
}
