% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids.R
\name{ids_download}
\alias{ids_download}
\title{Download and parse heritage metadata from a URL}
\usage{
ids_download(url, timeout = 60)
}
\arguments{
\item{url}{\code{Character.} The complete request URL.}

\item{timeout}{\code{Numeric.} Request timeout in seconds (default = \code{60}).}
}
\value{
A \code{data.frame} with columns:
\describe{
\item{id}{Numeric identifier extracted from the GUID.}
\item{title}{Record title as published in the service.}
\item{guid}{Full GUID (unique resource identifier).}
}
Returns an empty \code{data.frame} if the request fails or no items are found.
}
\description{
This internal helper performs an HTTP GET request to the given URL
(typically generated by \code{\link[=ids_url_build]{ids_url_build()}}) and parses the RSS XML
response into a structured \code{data.frame}.
}
\keyword{internal}
