% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_hooks.R
\name{git_hooks_install}
\alias{git_hooks_install}
\title{Install Git Pre-commit Hook}
\usage{
git_hooks_install(config_file = NULL, force = FALSE, verbose = TRUE)
}
\arguments{
\item{config_file}{Path to configuration file (default: "settings.yml")}

\item{force}{Logical; if TRUE, overwrite existing hook (default: FALSE)}

\item{verbose}{Logical; if TRUE (default), show installation messages}
}
\value{
Invisible TRUE on success, FALSE on failure
}
\description{
Creates a pre-commit hook that runs Framework checks based on settings.yml settings.
}
\details{
Creates or updates \code{.git/hooks/pre-commit} to run enabled Framework hooks:
\itemize{
\item \strong{ai_sync}: Sync AI assistant context files before commit
\item \strong{data_security}: Run security audit to catch data leaks
\item \strong{check_sensitive_dirs}: Warn about unignored sensitive directories
}

Hook behavior is controlled by \verb{git.hooks.*} settings in settings.yml.
}
\examples{
\donttest{
if (FALSE) {
# Install hooks based on settings.yml
git_hooks_install()

# Force reinstall (overwrites existing hook)
git_hooks_install(force = TRUE)
}
}

}
