% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_apply.R
\name{whiten}
\alias{whiten}
\title{Fit and apply whitening in one call}
\usage{
whiten(X, Y, runs = NULL, censor = NULL, ...)
}
\arguments{
\item{X}{Design matrix (time x regressors).}

\item{Y}{Data matrix (time x voxels).}

\item{runs}{Optional run labels.}

\item{censor}{Optional censor indices.}

\item{...}{Additional parameters passed to \code{\link[=fit_noise]{fit_noise()}}.}
}
\value{
List with whitened \code{X} and \code{Y} matrices.
}
\description{
Fit and apply whitening in one call
}
\examples{
# Create example data
n_time <- 200
n_pred <- 3
n_voxels <- 50
X <- matrix(rnorm(n_time * n_pred), n_time, n_pred)
Y <- X \%*\% matrix(rnorm(n_pred * n_voxels), n_pred, n_voxels) +
     matrix(rnorm(n_time * n_voxels, sd = 2), n_time, n_voxels)

# One-step whitening
whitened <- whiten(X, Y, method = "ar", p = 2)
}
