% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_filter.R
\name{fc_filter}
\alias{fc_filter}
\title{fc_filter}
\usage{
fc_filter(
  object,
  filter = NULL,
  N = NULL,
  label = NULL,
  text_pattern = "{label}\\n {n} ({perc}\%)",
  perc_total = FALSE,
  show_exc = FALSE,
  direction_exc = "right",
  label_exc = "Excluded",
  text_pattern_exc = "{label}\\n {n} ({perc}\%)",
  sel_group = NULL,
  round_digits = 2,
  trim_trailing_zeros = FALSE,
  just = "center",
  text_color = "black",
  text_fs = 8,
  text_fface = 1,
  text_ffamily = NA,
  text_padding = 1,
  bg_fill = "white",
  border_color = "black",
  width = NA,
  height = NA,
  just_exc = "center",
  text_color_exc = "black",
  text_fs_exc = 6,
  text_fface_exc = 1,
  text_ffamily_exc = NA,
  text_padding_exc = 1,
  bg_fill_exc = "white",
  border_color_exc = "black",
  offset_exc = NULL,
  width_exc = NA,
  height_exc = NA,
  title = NULL,
  x_title = 0.1,
  text_color_title = "black",
  text_fs_title = 10,
  text_fface_title = 1,
  text_ffamily_title = NA,
  text_padding_title = 0.6,
  bg_fill_title = "#B3D1FF",
  border_color_title = "black",
  width_title = NA,
  height_title = NA
)
}
\arguments{
\item{object}{fc object that we want to filter.}

\item{filter}{Expression that returns a logical value and are defined in terms of the variables in the data frame. The data base will be filtered by this expression, and it will create a box showing the number of rows satisfying this condition.}

\item{N}{Number of rows after the filter in case \code{filter} is \code{NULL}.}

\item{label}{Character or expression that will be the title of the box. By default it will be the evaluated condition.}

\item{text_pattern}{Character or expression defining the structure that will have the text in each of the boxes. It recognizes \code{label}, \code{n}, \code{N} and \code{perc} within brackets. For default it is \code{"{label}\\n {n} ({perc}\%)"}. If \code{text_pattern} or \code{label} is an expression, the \code{label} is always placed at the beginning of the pattern, followed by a line break where the structure specified by \code{text_pattern} is placed.}

\item{perc_total}{logical. Should percentages be calculated using the total number of rows at the beginning of the flowchart? Default is \code{FALSE}, meaning that they will be calculated using the number at the parent leaf.}

\item{show_exc}{Logical value. If \code{TRUE} a box showing the number of excluded rows will be added to the flow chart.}

\item{direction_exc}{One of \code{"left"} or \code{"right"} indicating if the exclusion box goes into the left direction or in the right direction. By default is \code{"right"}.}

\item{label_exc}{Character or expression that will be the title of the added box showing the excluded patients. By default it will show "Excluded".}

\item{text_pattern_exc}{Character or expression defining the structure that will have the text in the exclude box. It recognizes \code{label}, \code{n}, \code{N} and \code{perc} within brackets. For default it is \code{"{label}\\n {n} ({perc}\%)"}. If text_pattern or label is an expression, the label is always placed at the beginning of the pattern, followed by a line break where the structure specified by \code{text_pattern_exc} is placed.}

\item{sel_group}{Select the group in which to perform the filter. The default is \code{NULL}. Can only be used if the flowchart has previously been split. If the flowchart has more than one group, it can either be given the full name as it is stored in the \verb{$fc} component (separated by '\\'), or it can be given as a vector with the names of each group to be selected.}

\item{round_digits}{Number of digits to round percentages. It is 2 by default.}

\item{trim_trailing_zeros}{Logical value. If \code{TRUE}, allows trailing zeros after the decimal to be trimmed (default is \code{FALSE}).}

\item{just}{Justification for the text: \code{"left"}, \code{"center"} or \code{"right"}. Default is \code{"center"}.}

\item{text_color}{Color of the text. It is \code{"black"} by default. See the \code{col} parameter for \link{gpar}.}

\item{text_fs}{Font size of the text. It is 8 by default. See the \code{fontsize} parameter for \link{gpar}.}

\item{text_fface}{Font face of the text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily}{Changes the font family of the text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding}{Changes the text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill}{Box background color. It is \code{"white"} by default. See the \code{fill} parameter for \link{gpar}.}

\item{border_color}{Box border color. It is \code{"black"} by default. See the \code{col} parameter for \link{gpar}.}

\item{width}{Width of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height}{Height of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{just_exc}{Justification for the text of the exclude box: \code{"left"}, \code{"center"} or \code{"right"}. Default is \code{"center"}.}

\item{text_color_exc}{Color of the text of the exclude box. It is \code{"black"} by default. See \code{text_color}.}

\item{text_fs_exc}{Font size of the text of the exclude box. It is 6 by default. See \code{text_fs}.}

\item{text_fface_exc}{Font face of the text of the exclude box. It is 1 by default. See the \code{fontface} parameter for \link{gpar}. See \code{text_fface}.}

\item{text_ffamily_exc}{Changes the font family of the text of the exclude box. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}. See \code{text_ffamily}.}

\item{text_padding_exc}{Changes the text padding inside the exclude box. Default is 1. This number has to be greater than 0.}

\item{bg_fill_exc}{Exclude box background color. It is \code{"white"} by default. See \code{bg_fill}.}

\item{border_color_exc}{Box background color of the exclude box. It is \code{"black"} by default. See \code{border_color}.}

\item{offset_exc}{Amount of space to add to the distance between the box and the excluded box (in the x coordinate). If positive, this distance will be larger. If negative, it will be smaller. This number has to be at least between 0 and 1 (plot limits) and the resulting x coordinate cannot exceed these plot limits. The default is \code{NULL} (no offset).}

\item{width_exc}{Width of the exclude box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_exc}{Height of the box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{title}{Add a title box to the filter. Default is \code{NULL}.}

\item{x_title}{x-coordinate of the title box. Default is \code{0.1} (placed in the left).}

\item{text_color_title}{Color of the title text. It is \code{"black"} by default.}

\item{text_fs_title}{Font size of the title text. It is 8 by default.}

\item{text_fface_title}{Font face of the title text. It is 1 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily_title}{Changes the font family of the title text. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding_title}{Changes the title text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill_title}{Title box background color. It is \code{"white"} by default.}

\item{border_color_title}{Title box border color. It is \code{"black"} by default.}

\item{width_title}{Width of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_title}{Height of the title box. If \code{NA}, it automatically adjusts to the content (default). Must be an object of class \link{unit} or a number between 0 and 1.}
}
\value{
List with the filtered dataset and the flowchart parameters with the resulting filtered box.
}
\description{
This function allows to filter the flowchart in function of a expression that returns a logic value that are defined in terms of the variables in the database. It will generate one box per group showing the number of rows of the group that matches the condition, and will retain only those rows in the data base.
}
\examples{
safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
  fc_draw()

}
