% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.R
\name{fix}
\alias{fix}
\alias{fix_dir}
\alias{fix_package}
\alias{fix_text}
\title{Automatically replace lints}
\usage{
fix(
  path,
  linters = NULL,
  exclude_path = NULL,
  exclude_linters = NULL,
  force = FALSE,
  verbose = TRUE,
  rerun = TRUE,
  interactive = FALSE
)

fix_dir(
  path,
  linters = NULL,
  exclude_path = NULL,
  exclude_linters = NULL,
  force = FALSE,
  verbose = TRUE,
  rerun = TRUE,
  interactive = FALSE
)

fix_package(
  path,
  linters = NULL,
  exclude_path = NULL,
  exclude_linters = NULL,
  force = FALSE,
  verbose = TRUE,
  rerun = TRUE,
  interactive = FALSE
)

fix_text(text, linters = NULL, exclude_linters = NULL, rerun = TRUE)
}
\arguments{
\item{path}{A valid path to a file or a directory. Relative paths are
accepted. Contrarily to \code{lint()} and its variants, this must be specified.}

\item{linters}{A character vector with the names of the rules to apply. See
the entire list of rules with \code{list_linters()}. If you have set up the
\code{flir} folder with \code{setup_flir()}, you can also list the linters to use
in the \code{keep} field of \code{flir/config.yml}. See \code{\link[=setup_flir]{setup_flir()}} for more
information.}

\item{exclude_path}{One or several paths that will be ignored from the \code{path}
selection.}

\item{exclude_linters}{One or several linters that will not be checked.
Values can be the names of linters (such as \code{"any_is_na"}) or its
associated function, such as \code{any_is_na_linter()} (this is mostly for
compatibility with \code{lintr}). If you have set up the \code{flir} folder with
\code{setup_flir()}, you can also list the linters to exclude in the \code{exclude}
field of \code{flir/config.yml}. See \code{\link[=setup_flir]{setup_flir()}} for more information.}

\item{force}{Force the application of fixes on the files. This is used only
in the case where Git is not detected, several files will be modified, and
the code is run in a non-interactive setting.}

\item{verbose}{Show messages.}

\item{rerun}{Run the function several times until there are no more fixes to
apply. This is useful in the case of nested lints. If \code{FALSE}, the function
runs only once, potentially ignoring nested fixes.}

\item{interactive}{Opens a Shiny app that shows a visual diff of each
modified file. This is particularly useful when you want to review the
potential fixes before accepting them. Setting this to \code{TRUE} will disable
the check on whether Git is used.}

\item{text}{Text to analyze (and to fix if necessary).}
}
\value{
A list with as many elements as there are files to fix (in \code{fix_text()},
the text is written to a temporary file).

Each element of the list contains the fixed text, where all fixes available
have been applied.
}
\description{
\code{fix()}, \code{fix_package()}, and \code{fix_dir()} all replace lints in files. The
only difference is in the input they take:
\itemize{
\item \code{fix()} takes path to files or directories
\item \code{fix_dir()} takes a path to one directory
\item \code{fix_package()} takes a path to the root of a package and looks at the
following list of folders: \code{R}, \code{tests}, \code{inst}, \code{vignettes}, \code{data-raw},
\code{demo}, \code{exec}.
}

\code{fix_text()} takes some text input. Its main interest is to be able to
quickly experiment with some lints and fixes.
}
\section{Ignoring lines}{


\code{flir} supports ignoring single lines of code with \verb{# flir-ignore}. For
example, this will not warn:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore
any(duplicated(x))
}\if{html}{\out{</div>}}

However, this will warn for the second \code{any(duplicated())}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore
any(duplicated(x))
any(duplicated(y))
}\if{html}{\out{</div>}}

To ignore more than one line of code, use \verb{# flir-ignore-start} and
\verb{# flir-ignore-end}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# flir-ignore-start
any(duplicated(x))
any(duplicated(y))
# flir-ignore-end
}\if{html}{\out{</div>}}
}

\examples{
# `fix_text()` is convenient to explore with a small example
fix_text("any(duplicated(rnorm(5)))")

fix_text("any(duplicated(rnorm(5)))
any(is.na(x))
")

# Setup for the example with `fix()`
destfile <- tempfile()
cat("
x = c(1, 2, 3)
any(duplicated(x), na.rm = TRUE)

any(duplicated(x))

if (any(is.na(x))) {
  TRUE
}

any(
  duplicated(x)
)", file = destfile)

fix(destfile)
cat(paste(readLines(destfile), collapse = "\n"))
}
