% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{getEffectiveSubspace}
\alias{getEffectiveSubspace}
\title{Get Effective Subspace}
\usage{
getEffectiveSubspace(results, newdata = NULL, alpha = 0.05, pip_cutoff = 0.1)
}
\arguments{
\item{results}{A fitted model object from \code{rjMCMC}.}

\item{newdata}{Optional. A new dataset for evaluating the effective subspace.
If \code{NULL}, the function uses \code{results$data_fit}.}

\item{alpha}{Numeric. The alpha level used for computing quantiles. Default is \code{0.05}.}

\item{pip_cutoff}{Numeric. The minimum Posterior Inclusion Probability (PIP)
threshold for selecting covariates. Default is \code{0.1}.}
}
\value{
A list with the following components:
\item{quantiles}{A vector of quantile values for the exposure effect in the new dataset.}
\item{is_effective_subspace}{A logical vector indicating whether the exposure effect is
positive in the effective subspace.}
}
\description{
This function identifies the "effective subspace" where exposure is effective
based on posterior inference results from the FK-BMA model. It analyzes interaction terms
between exposure and covariates, allowing for both binary and continuous variables.
}
\details{
\itemize{
\item The function computes the posterior exposure effect for each observation in the
dataset using the \code{fittedExposureEff} function and evaluates its quantiles at the
specified \code{alpha} level.
\item Binary variables with high posterior inclusion probabilities (PIP) are used to define
subgroups, and the corresponding effective subspaces for a continuous variable
are identified by checking where the exposure effect quantiles are strictly positive.
\item If the number of binary variables is \code{<= 3} and there is exactly one continuous variable,
the function describes the effective subspace in terms of disjoint intervals.
\item For more complex cases, a warning is issued suggesting alternative methods such as
Bayesian regression trees for interpretation.
}
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
getEffectiveSubspace(results)
}
}
