% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_newdata.R
\name{ff_expand}
\alias{ff_expand}
\alias{finalfit_expand}
\title{Summarise with mode and mean/median and expand given factors}
\usage{
ff_expand(.data, ..., cont = "mean")

finalfit_expand(.data, ..., cont = "mean")
}
\arguments{
\item{.data}{A data frame or tibble.}

\item{...}{Factors to expand.}

\item{cont}{One of "mean" or "median": the summary estimate for continuous variables.}
}
\value{
A data frame or tibble with the mode for factors and mean/median 
for continuous variables, with given factors expanded to include all levels.
}
\description{
When producing conditional estimates from a regression model, it is often useful
to set variables not of interest to their mode for factors and mean or median for numerics
when creating the newdata object, and combine these with all levels for factors of interest.
}
\examples{
library(dplyr)
colon_s \%>\% 
select(-hospital) \%>\% 
ff_expand(age.factor, sex.factor)
}
\seealso{
\code{\link{ff_mode}} \code{\link{summary_df}}
}
