% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrridge}
\alias{qrridge}
\title{RIDGE estimation for the linear regression model}
\usage{
qrridge(y, X, lambda, X_test = NULL, type = NULL)
}
\arguments{
\item{y}{a vector of length-\eqn{n} response vector.}

\item{X}{an \eqn{(n\times p)} matrix of predictors.}

\item{lambda}{a vector of lambdas.}

\item{X_test}{an \eqn{(q\times p)} full column rank matrix. Test set. By default it set to NULL.}

\item{type}{either "QR" or "R". Specifies the type of decomposition to use: "QR" for the QR decomposition or "R" for the Cholesky factorization of \eqn{A^\top A}. The default is "QR".}
}
\value{
A named list containing \describe{
\item{mean_y}{mean of the response variable.}
\item{mean_X}{a length-\eqn{p} vector containing the mean of each column of the design matrix.}
\item{path}{the whole path of estimated regression coefficients.}
\item{ess}{explained sum of squares for the whole path of estimated coefficients.}
\item{GCV}{generalized cross-validation for the whole path of lambdas.}
\item{GCV_min}{minimum value of GCV.}
\item{GCV_idx}{inded corresponding to the minimum values of GCV.}
\item{coeff}{a length-\eqn{p} vector containing the solution for the parameters \eqn{\beta} which corresponds to the minimum of GCV.}
\item{lambda}{the vector of lambdas.}
\item{scales}{the vector of standard deviations of each column of the design matrix.}
}
}
\description{
lmridge, or RIDGE for linear regression models, solves the following penalized optimization problem
\deqn{\textrm{min}_\beta ~ \frac{1}{n}\|y-X\beta\|_2^2+\lambda\Vert\beta\Vert_2^2,}
to obtain a coefficient vector \eqn{\widehat{\beta}\in\mathbb{R}^{p}}. The design matrix \eqn{X\in\mathbb{R}^{n\times p}}
contains the observations for each regressor.
}
\examples{

## generate sample data
set.seed(10)
n         <- 30
p         <- 6
X         <- matrix(rnorm(n * p, 1), n, p)
X[,1]     <- 1
eps       <- rnorm(n, sd = 0.5)
beta      <- rep(0, p)
beta[1:3] <- 1
beta[4:5] <- 2
y         <- X \%*\% beta + eps
X_test    <- matrix(rnorm(5 * p, 1), 5, p)
output    <-  fastQR::qrridge(y = y, X = X,
                              lambda = 0.2,
                              X_test = X_test)
output$coeff

}
