% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_resid}
\alias{qr_resid}
\title{Compute residuals from a QR decomposition}
\usage{
qr_resid(qr, tau, y)
}
\arguments{
\item{qr}{numeric matrix containing the QR decomposition of \eqn{X}
in compact form (as returned by \code{qr_fast()}).}

\item{tau}{numeric vector of Householder coefficients.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector of residuals of dimension \eqn{n}.
}
\description{
Computes the residual vector \eqn{r = y - \widehat y} for a linear
least-squares problem using a QR decomposition stored in compact
(Householder) form.
}
\details{
The residuals are computed as
\deqn{r = y - Q Q^\top y}
without explicitly forming the orthogonal matrix \eqn{Q}. The
computation relies on the Householder reflectors stored in
\code{qr} and \code{tau}.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

qr_res <- fastQR::qr_fast(X)
r1     <- fastQR::qr_resid(qr = qr_res$qr, tau = qr_res$qraux, y = y)

## reference computation
r2 <- base::qr.resid(base::qr(X), y)

max(abs(r1 - r2))

}
