% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ez_map.R
\name{ez_map}
\alias{ez_map}
\title{Plot Tracking Data and Home Ranges Together}
\usage{
ez_map(
  tracks = NULL,
  home_ranges = NULL,
  individual = NULL,
  show_points = TRUE,
  show_paths = TRUE,
  point_color = "id",
  point_size = 4,
  point_opacity = 0.8,
  point_stroke = TRUE,
  point_stroke_color = "black",
  path_color = "id",
  path_width = 2,
  path_opacity = 1,
  polygon_color = "id",
  polygon_opacity = 0.4,
  color_palette = "viridis",
  show_labels = TRUE,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{tracks}{Output from `ez_track()` — a data frame or `sf` with `id`, `timestamp`, `x`, `y`.}

\item{home_ranges}{Output from `ez_home_range()` — an `sf` polygon object.}

\item{individual}{Optional. Character or character vector of individual ID(s) to display.}

\item{show_points}{Logical, whether to draw individual locations. Default TRUE.}

\item{show_paths}{Logical, whether to draw movement paths. Default TRUE.}

\item{point_color}{Column name or static color for points. Default "id". Can also be "timestamp" for temporal gradient.}

\item{point_size}{Radius of point markers. Default 4.}

\item{point_opacity}{Fill opacity of points. Default 0.8.}

\item{point_stroke}{Logical, whether to draw point borders. Default TRUE.}

\item{point_stroke_color}{Border color for points. Default "black".}

\item{path_color}{Column name or static color for paths. Default "id".}

\item{path_width}{Line width of movement paths. Default 2.}

\item{path_opacity}{Opacity of path lines. Default 1.}

\item{polygon_color}{Column name or static color for home range polygons. Default "id".}

\item{polygon_opacity}{Fill opacity of polygons. Default 0.4.}

\item{color_palette}{Color palette to use for all mapped variables. Default "viridis".}

\item{show_labels}{Logical, whether to show hover labels for locations. Default TRUE.}

\item{start_date}{Optional filter (Date or string) to remove data before this date.}

\item{end_date}{Optional filter (Date or string) to remove data after this date.}
}
\value{
A `leaflet` map object.
}
\description{
A unified function for visualizing tracking data and home range polygons on an interactive map.
Accepts tracking points (from `ez_track`) and home ranges (from `ez_home_range`), and
allows layer-specific customization of appearance and filtering by time.
}
\examples{
# Simulate tracks
tracks <- data.frame(
  id = rep(c("A", "B"), each = 10),
  timestamp = rep(seq.POSIXt(as.POSIXct("2023-01-01"), by = "1 day", length.out = 10), 2),
  x = c(runif(10, -1, 1), runif(10, 0, 2)),
  y = c(runif(10, 51, 52), runif(10, 51.5, 52.5))
)

# Plot map
ez_map(tracks, point_color = "timestamp")
}
