% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va.R
\name{va_mixed}
\alias{va_mixed}
\title{VA classes}
\usage{
va_mixed(x, to = "logmar", possible = c("snellen", "etdrs", "logmar", "quali"))
}
\arguments{
\item{x}{vector with mixed VA entries}

\item{to}{to which notation to be converted}

\item{possible}{possible VA notations. The order defines which class
will be prioritised if a value can be from more than one class, see details.
Default = c("snellen", "etdrs", "logmar", "quali")}
}
\description{
va_mixed is a wrapper around \link{va} on all possible VA notations.
By default, c("snellen", "etdrs", "logmar", "snellendec") will be converted -
in that order! For tricky cases see details and examples. Note
that va_mixed will not notify you from which notation the values
were transformed, nor if values were replaced with NA.
}
\details{
Mixed entries are challenging, but unfortunately seem to occur in
real life data. It will be fairly individual what you have in yours, but
it should hopefully not happen that you have \emph{all} possible notations.
Snellen fractions are usually not challenging because they contain a "/",
thus are easy to recognize.

\strong{Values between 0 and 3 are most problematic},
in particular full integers - this can be EDTRS, snellen decimal notation
or logmar. By default, snellen decimal are not recognized, but you can
specify this with the "possible" argument.
Or, if you know that you don't have any ETDRS value less than 4,
you can safely give precedence to logmar instead, like this:
\code{possible = c("snellen", "logmar", "etdrs")}
@examples
}
\section{awfully mixed notation!! (and note the wrong -1 value)}{
x <- c(NA, "nlp", 1:2, 1.1, -1, "20/40", "4/6", "6/1000", 34)
va_mixed(x, to = "snellen")
}

\section{"I only have snellen and snellen decimal notation in my data"}{
va_mixed(x, to = "snellen", possible = c("snellen", "snellendec"))
}

\section{"I have snellen, logmar and etdrs in my data, and there is no etdrs value}{
less than 4"
va_mixed(x, to = "snellen", possible = c("snellen", "logmar", "etdrs"))
}

\seealso{
Other Ophthalmic functions: 
\code{\link{va}()}

Other VA converter: 
\code{\link{VAwrapper}},
\code{\link{plausibility_methods}},
\code{\link{snellen_steps}},
\code{\link{va}()},
\code{\link{va_methods}},
\code{\link{which_va}()}
}
\concept{Ophthalmic functions}
\concept{VA converter}
