% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf_sb.R
\name{radf_sb_cv}
\alias{radf_sb_cv}
\alias{radf_sb_distr}
\title{Panel Sieve Bootstrap Critical Values}
\usage{
radf_sb_cv(data, minw = NULL, lag = 0L, nboot = 500L, seed = NULL)

radf_sb_distr(data, minw = NULL, lag = 0L, nboot = 500L, seed = NULL)
}
\arguments{
\item{data}{A univariate or multivariate numeric time series object, a numeric
vector or matrix, or a data.frame. The object should not have any NA values.}

\item{minw}{A positive integer. The minimum window size (default =
\eqn{(0.01 + 1.8/\sqrt(T))T}{(0.01 + 1.8 / \sqrtT)T}, where T denotes the sample size).}

\item{lag}{A non-negative integer. The lag length of the Augmented Dickey-Fuller regression (default = 0L).}

\item{nboot}{A positive integer. Number of bootstraps (default = 500L).}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
For \code{radf_sb_cv} A list A list that contains the critical values
for the panel BSADF and panel GSADF test statistics. For \code{radf_wb_dist} a numeric vector
that contains the distribution of the panel GSADF statistic.
}
\description{
\code{radf_sb_cv} computes critical values for the panel recursive unit root test using
the sieve bootstrap procedure outlined in Pavlidis et al. (2016). \code{radf_sb_distr}
computes the distribution.
}
\examples{
\donttest{

rsim_data <- radf(sim_data, lag = 1)

# Critical vales should have the same lag length with \code{radf()}
sb <- radf_sb_cv(sim_data, lag = 1)

tidy(sb)

summary(rsim_data, cv = sb)

autoplot(rsim_data, cv = sb)

# Simulate distribution
sdist <- radf_sb_distr(sim_data, lag = 1, nboot = 1000)

autoplot(sdist)
}
}
\references{
Pavlidis, E., Yusupova, A., Paya, I., Peel, D., Martínez-García,
E., Mack, A., & Grossman, V. (2016). Episodes of exuberance in housing markets:
In search of the smoking gun. The Journal of Real Estate Finance and Economics, 53(4), 419-449.
}
\seealso{
\code{\link{radf_mc_cv}} for Monte Carlo critical values and
\code{\link{radf_wb_cv}} for wild Bootstrap critical values
}
