% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incomplete_table.R
\name{incomplete_table}
\alias{incomplete_table}
\alias{cont_table_fill}
\title{Relative Contingency Table Fill}
\usage{
incomplete_table(tab, n, maxit = 1000)

cont_table_fill(tab, n, maxit = 1000)
}
\arguments{
\item{tab}{table: a contingency table}

\item{n}{integer: number of missing values}

\item{maxit}{integer: number of maximal iterations (default: \code{1000})}
}
\value{
A contingency table including marginal values and total sum with missing values.
The attribute \code{fillin} gives the necessary information about the order in which the entries can be calculated,
while the attribute \code{full} presents the contingency table, including marginal values and total sum.
}
\description{
Fills a relative contingency table with \code{n} missing values, such that the table entries can be
recomputed. In case that no solution can be found, an error is generated.
}
\examples{
tab <- rbind(c(0.02, 0.04, 0.34), c(0.02, 0.28, 0.3))
incomplete_table(tab, 7)
}
