% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand.R
\name{expand_sessions}
\alias{expand_sessions}
\title{Expand sessions along time slots}
\usage{
expand_sessions(sessions, resolution)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{evprof} package}

\item{resolution}{integer, time resolution (in minutes) of the time slots}
}
\value{
tibble
}
\description{
Every session in \code{sessions} is divided in multiple time slots
with the corresponding \code{Power} consumption, among other variables.
}
\details{
The \code{Power} value is calculated for every time slot according to the original
required energy. The columns \code{PowerNominal}, \code{EnergyRequired} and
\code{FlexibilityHours} correspond to the values of the original session, and not
to the expanded session in every time slot. The column \code{ID} shows the number
of the time slot corresponding to the original session.
}
\examples{
library(dplyr)

sessions <- head(evsim::california_ev_sessions, 10)
expand_sessions(
  sessions,
  resolution = 60
)

}
