% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netlogo-helper.R
\name{NLWrapper.RunExperiment}
\alias{NLWrapper.RunExperiment}
\title{NLWrapper.RunExperiment}
\usage{
NLWrapper.RunExperiment(obj, r = 1, design, FUN)
}
\arguments{
\item{obj}{The object retuned by \link{NLWrapper.Model}}

\item{r}{The number of replications}

\item{design}{The desing matrix holding parameter sampling}

\item{FUN}{THe calibration function.}
}
\value{
A list containing the the parameters, the calibration functio output and the whole resultset
}
\description{
Executes a NetLogo Model using rNetLogo
}
\examples{
\dontrun{
   rm(list=ls())
   objectivefn<- function(params, results) { 0 }

   f<- AddFactor(name="initial-number-sheep",min=100,max=250)
   f<- AddFactor(factors=f, name="initial-number-wolves",min=50,max=150)
   f<- AddFactor(factors=f, name="grass-regrowth-time",min=30,max=100)
   f<- AddFactor(factors=f, name="sheep-gain-from-food",min=1,max=50)
   f<- AddFactor(factors=f, name="wolf-gain-from-food",min=1,max=100)
   f<- AddFactor(factors=f, name="sheep-reproduce",min=1,max=20)
   f<- AddFactor(factors=f, name="wolf-reproduce",min=1,max=20)

   design<- AoE.LatinHypercube(factors=f)

   p<- "C:/Program Files/NetLogo 6.1.1/app"
   m<- file.path(p, "models", "Sample Models", "Biology", "Wolf Sheep Predation.nlogo")
   output<- c("count sheep", "count wolves")
   o<- NLWrapper.Model(p, m, output, 150)
   v<- RunExperiment(o, r=1, design, objectivefn)
   NLWrapper.Shutdown(o)
}

}
