% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_p_operator.R
\name{\%p\%}
\alias{\%p\%}
\title{\verb{\%p\%}: paste two strings with a single space}
\usage{
lhs \%p\% rhs
}
\arguments{
\item{lhs}{A character vector on the left-hand side.}

\item{rhs}{A character vector on the right-hand side.}
}
\value{
A character vector, concatenating \code{lhs} and \code{rhs} with a single space.
}
\description{
An infix operator for string concatenation with one space between \code{lhs} and \code{rhs}.
Inspired by the readability of \verb{\%>\%}, intended for expressive text building.
}
\examples{
"Hello" \%p\% "world"
"Good" \%p\% "job"
c("hello", "good") \%p\% c("world", "morning")   # vectorized
}
