% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_palette.R
\name{create_palette}
\alias{create_palette}
\title{create_palette(): Save Custom Color Palettes as JSON}
\usage{
create_palette(
  name,
  type = c("sequential", "diverging", "qualitative"),
  colors,
  color_dir,
  log = TRUE
)
}
\arguments{
\item{name}{Character. Palette name (e.g., "Blues").}

\item{type}{Character. One of "sequential", "diverging", or "qualitative".}

\item{colors}{Character vector of HEX color values (e.g., "#E64B35" or "#E64B35B2").}

\item{color_dir}{Character. Root folder to store palettes (required). Use tempdir() for examples/tests.}

\item{log}{Logical. Whether to log palette creation to a temporary log file.}
}
\value{
(Invisibly) A list with \code{path} and \code{info}.
}
\description{
Save a named color palette (sequential, diverging, or qualitative) to a JSON file.
Used for palette sharing, reuse, and future compilation.
}
\examples{
# Create palette in temporary directory:
temp_dir <- file.path(tempdir(), "palettes")
create_palette(
  "blues",
  "sequential",
  c("#deebf7", "#9ecae1", "#3182bd"),
  color_dir = temp_dir
)

create_palette(
  "vividset",
  "qualitative",
  c("#E64B35", "#4DBBD5", "#00A087"),
  color_dir = temp_dir
)

# Clean up
unlink(temp_dir, recursive = TRUE)
}
