% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{tripercent-ergmTerm}
\alias{tripercent-ergmTerm}
\alias{InitErgmTerm.tripercent}
\title{Triangle percentage}
\usage{
# binary: tripercent(attr=NULL, diff=FALSE, levels=NULL)
}
\arguments{
\item{attr, diff}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.) If \code{attr} is specified and \code{diff} is \code{FALSE} ,
then the counts are restricted to those triples of nodes with
equal values of the vertex attribute specified by \code{attr} . If \code{attr} is specified and \code{diff} is \code{TRUE} ,
then one statistic is added for each value of \code{attr} ,
equal to the number of triangles where all three nodes have that value of the attribute.}

\item{levels}{add one statistic for each value specified if \code{diff} is \code{TRUE} should be included and which should be excluded. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
By default, this term adds one statistic to the model equal to 100 times the ratio of
the number of triangles in the network to the sum of the number of triangles
and the number of 2-stars not in triangles (the latter is considered a
potential but incomplete triangle). In case the denominator equals zero,
the statistic is defined to be zero. For the definition of triangle, see
\code{triangle} . This is often called
the mean correlation coefficient. This term can only be
used with undirected networks; for directed networks, it is difficult to
define the numerator and denominator in a consistent and meaningful way.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "tripercent", "subsection")}
}
\concept{categorical nodal attribute}
\concept{triad-related}
\concept{undirected}
