% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{edge_load_ollama_model}
\alias{edge_load_ollama_model}
\title{Load an Ollama model by partial SHA-256 hash}
\usage{
edge_load_ollama_model(partial_hash, n_ctx = 2048L, n_gpu_layers = 0L)
}
\arguments{
\item{partial_hash}{First few characters of the SHA-256 hash}

\item{n_ctx}{Maximum context length (default: 2048)}

\item{n_gpu_layers}{Number of layers to offload to GPU (default: 0)}
}
\value{
Model context if successful, throws error if not found or incompatible
}
\description{
Find and load an Ollama model using a partial SHA-256 hash instead of the full path.
This is more convenient than typing out the full blob path.
}
\examples{
\dontrun{
# Load model using first 8 characters of SHA hash
# ctx <- edge_load_ollama_model("b112e727")
# result <- edge_completion(ctx, "Hello", n_predict = 10)
# edge_free_model(ctx)
}
}
