% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_gdp_column}
\alias{add_gdp_column}
\title{Add GDP to Country Data}
\usage{
add_gdp_column(
  df,
  id_column,
  id_type = "iso3_code",
  date_column = NULL,
  target_column = "gdp",
  usd = TRUE
)
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{id_type}{Type of country identifier. Defaults to "iso3_code".}

\item{date_column}{Optional. Name of the column containing dates for
time-specific data.}

\item{target_column}{Name of the output column. Defaults to "gdp".}

\item{usd}{Logical. Indicates whether GDP should be in USD or local currency.
Defaults to "TRUE".}
}
\value{
A data frame with an additional column containing GDP data.
}
\description{
Add GDP to Country Data
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Add most recent GDP values
df <- data.frame(country = c("USA", "CHN", "DEU"))
result <- add_gdp_column(df, id_column = "country")

# Add year-specific GDP values
df <- data.frame(country = c("USA", "CHN"), year = c(2019, 2020))
result <- add_gdp_column(df, id_column = "country", date_column = "year")
}
\dontshow{\}) # examplesIf}
}
