% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emp_misc.R
\docType{package}
\name{easyPubMed-package}
\alias{easyPubMed}
\alias{easyPubMed-package}
\title{Retrieve and Process Scientific Publication Records from Pubmed}
\description{
Query NCBI Entrez and retrieve PubMed records in XML or TXT format. PubMed records 
can be downloaded and saved as XML or text files. Data integrity is enforced during data download, 
allowing to retrieve and save very large number of records effortlessly. PubMed records can be processed 
to extract publication- and author-specific information.
}
\details{
This software is based on the information 
included in the Entrez Programming Utilities Help manual 
authored by Eric Sayers, PhD and available on the NCBI Bookshelf (NBK25500).
This R library is NOT endorsed, supported, maintained NOR affiliated with NCBI.
}
\examples{
## Example 01: retrieve data in XML format, extract info, show
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  my_query_string <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  epm <- epm_query(my_query_string)
  epm <- epm_fetch(epm)
  epm <- epm_parse(epm, max_authors = 5, max_references = 10)
  processed_data <- get_epm_data(epm)
  utils::head(processed_data)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

\dontrun{
## Example 02: retrieve data in medline format
my_query_string <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
epm <- epm_query(my_query_string)
epm <- epm_fetch(epm, format = 'medline')
medline_data <- get_epm_raw(epm)
first_record <- medline_data[[1]] 
cat(first_record, sep = '\n')


## Additional Examples: show easyPubMed Vignette
library(easyPubMed)
vignette("easyPubMed_demo")

}

}
\references{
\itemize{
  \item Tutorials and Help Webpage: \url{https://www.data-pulse.com/dev_site/easypubmed/}
  \item NCBI PubMed Help Manual: \url{https://pubmed.ncbi.nlm.nih.gov/help/}
  \item Entrez Programming Utilities Help (NBK25500): \url{https://www.ncbi.nlm.nih.gov/books/NBK25500/}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.data-pulse.com/dev_site/easypubmed/}
}

}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
\keyword{internal}
