% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_track}
\alias{p_track}
\title{Start tracking the dtrackr history graph}
\usage{
p_track(
  .data,
  .messages = .defaultMessage(),
  .headline = .defaultHeadline(),
  .tag = NULL
)
}
\arguments{
\item{.data}{a dataframe which may be grouped}

\item{.messages}{a character vector of glue specifications. A glue
specification can refer to any grouping variables of .data, or any
variables defined in the calling environment, the \{.total\} variable which
is the count of all rows, the \{.count\} variable which is the count of
rows in the current group and the \{.strata\} which describes the current
group. Defaults to the value of \code{getOption("dtrackr.default_message")}.}

\item{.headline}{a glue specification which can refer to grouping variables
of .data, or any variables defined in the calling environment, or the
\{.total\} variable which is \code{nrow(.data)}, or \{.strata\} a summary of the
current group. Defaults to the value of \code{getOption("dtrackr.default_headline")}.}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the .data dataframe with additional history graph metadata, to allow
tracking.
}
\description{
Start tracking the dtrackr history graph
}
\examples{
library(dplyr)
library(dtrackr)
iris \%>\% track() \%>\% history()
}
