% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_transitions.R
\name{dtms_transitions}
\alias{dtms_transitions}
\title{Predict transition probabilities}
\usage{
dtms_transitions(
  model,
  dtms,
  controls = NULL,
  dropvar = TRUE,
  timevar = "time",
  fromvar = "from",
  tovar = "to",
  Pvar = "P",
  se = TRUE,
  vcov = FALSE,
  ci = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{model}{Model estimated with \code{dtms_fit}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{controls}{List (optional) with values for predictors (see details).}

\item{dropvar}{Logical (optional), should covariate values used for prediction be returned (see details). Default is `TRUE`.}

\item{timevar}{Character (optional), name of variable with time scale in the returned data frame. Default is `time`.}

\item{fromvar}{Character (optional), name of variable with starting state in the returned data frame. Default is `from`.}

\item{tovar}{Character (optional), name of variable with receiving state in the returned data frame. Default is `to`.}

\item{Pvar}{Character (optional), name of variable with transition probabilities in the returned data frame. Default is `P`.}

\item{se}{Logical (optional), return standard errors of predicted probabilities. Default is `TRUE`.}

\item{vcov}{Logical (optional), return variance-covariance matrix of predicted probabilities. Default is `FALSE`.}

\item{ci}{Logical (optional), return confidence intervals? See details. Default is FALSE.}

\item{alpha}{Numeric (optional), if ci=TRUE, what confidence level is used? Default is 0.05.}
}
\value{
A data frame with transition probabilities.
}
\description{
`dtms_transitions()` predicts transition probabilities based on a model
estimated with `dtms_fit()`.
}
\details{
Depending on the model specification, the prediction of transition
probabilities will require values for predictor variables which can be
specified with the argument `controls`. This is done using a named list
where each entry name must correspond to a variable name in the model.
For time-constant variables, each list entry is of length one and provides
a value for the corresponding time-constant variable. For time-varying
variables, each entry must have the length of the time scale minus one, and
provide a value for each (potential) transition in the model; i.e., starting
from time t=0, starting from time t=1, etc., until time t=T-1. Alternatively,
it can be of the same length as the time scale; in this case, the last value
is dismissed.

If `vcov=TRUE` the full variance-covariance matrix of the transition
probabilities will be returned instead of the transition probabilities. If
`ci=TRUE`, confidence intervals will be returned. Note that the calculation
uses a normal approximation and results below 0 or above 1 are possible.

The argument `dropvar` controls whether the covariate values used for
prediction are dropped. If `FALSE` each row of the resulting data frame will
have the covariate values which were used to predict the corresponding
probability.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
}
