% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_reward.R
\name{dtms_reward}
\alias{dtms_reward}
\title{Markov chain with rewards}
\usage{
dtms_reward(probs = NULL, matrix = NULL, reward, dtms)
}
\arguments{
\item{probs}{Data frame with transition probabilities, as created with \code{dtms_transitions}.}

\item{matrix}{Matrix with transition probabilities, as generated with \code{dtms_matrix}.}

\item{reward}{Matrix with rewards, has to be of same dimensions as `matrix` or the matrix which will result from `probs`.}

\item{dtms}{dtms object, as created with \code{dtms}.}
}
\value{
A matrix with expected rewards.
}
\description{
This function calculates the expected rewards by starting state in a
Markov chain with rewards.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
# Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
## Get transition matrix
Tp <- dtms_matrix(dtms=simple,
                  probs=probs)
## Reward matrix
Rw <- diag(1,dim(Tp)[1])
## State expectancies
dtms_reward(dtms=simple,
            matrix=Tp,
            reward=Rw)
}
\seealso{
[dtms_rewardmatrix()]
}
