% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{total_events}
\alias{total_events}
\title{Count total events}
\usage{
total_events(dt, treat, label)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variable indicated in
\code{treat}.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{label}{A string to be used as label in the output reporting table. This
should be a text descriptive of the event being counted.}
}
\value{
A list wrapping a one-row \code{data.table} of \code{1 + n} variables, where
\code{n} is the number of levels in \code{treat}. First variable is \code{stats},
\code{character} type, whose value is the argument passed in as \code{label}.
Following variables are of \code{integer} type and provide the counts.
}
\description{
\code{\link[=total_events]{total_events()}} counts the number of observations in \code{dt} in each group
defined by \code{treat} levels. Counts are returned in wide format, i.e. one
column per level in \code{treat}.
}
\examples{
# In the absence of pre-filtering, `total_events()`, actually, just counts
# observations in `dt`.
total_events(dt = adsl, treat = "ARM", label = "Subjects")[[1]]

# If `dt` is pre-filtered, e.g. with a condition matching an event, then
# `total_events()` can be used to (effectively) count events.
total_events(dt = adsl[adsl$DTHFL == 'Y'], treat = "ARM", label = "Deaths")[[1]]

# Another example using the complement predicate condition.
total_events(dt = adsl[adsl$DTHFL == 'N'], treat = "ARM", label = "Lives")[[1]]

}
