% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{simRegression}
\alias{simRegression}
\title{Simulate noisy observations from a dynamic regression model}
\usage{
simRegression(
  nT = 200,
  p = 20,
  p_0 = 15,
  sparsity = 0.05,
  RSNR = 5,
  ar1 = 0,
  include_plot = FALSE
)
}
\arguments{
\item{nT}{number of time points}

\item{p}{number of predictors (total)}

\item{p_0}{number of true zero regression terms}

\item{sparsity}{the probability of a jump
(i.e., a change in the dynamic regression coefficient)}

\item{RSNR}{root-signal-to-noise ratio}

\item{ar1}{the AR(1) coefficient for the predictors X; default is zero for iid N(0,1) predictors}

\item{include_plot}{logical; if TRUE, include a plot of the simulated data and the true curve}
}
\value{
a list containing
\itemize{
\item the simulated function \code{y}
\item the simulated predictors \code{X}
\item the simulated dynamic regression coefficients \code{beta_true}
\item the true function \code{mu_true}
\item the true observation standard deviation \code{sigma_true}
}
}
\description{
Simulates data from a time series regression with dynamic regression coefficients.
The dynamic regression coefficients are simulated as a Gaussian random walk,
where jumps occur with a pre-specified probability \code{sparsity}.
The coefficients are initialized by a N(0,1) simulation.
}
\note{
The root-signal-to-noise ratio is defined as RSNR = (sd of true function)/(sd of noise).
}
