
<!-- README.md is generated from README.Rmd. Please edit THIS (Rmd) file. -->
<!-- Devel badges start: -->
<!-- [![CRAN status](https://www.r-pkg.org/badges/version/ds4psy)](https://CRAN.R-project.org/package=ds4psy) -->
<!-- [![Downloads/month](https://cranlogs.r-pkg.org/badges/ds4psy?color="00a9e0")](https://www.r-pkg.org/pkg/ds4psy) -->
<!-- [![Total downloads](https://cranlogs.r-pkg.org/badges/grand-total/ds4psy?color=blue)](https://www.r-pkg.org/pkg/ds4psy) -->
<!-- [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7229812.svg)](https://doi.org/10.5281/zenodo.7229812) -->
<!-- Devel badges end. -->
<!-- <!-- Release badges start: -->

[![CRAN
status](https://www.r-pkg.org/badges/version/ds4psy)](https://CRAN.R-project.org/package=ds4psy)
[![Total
downloads](https://cranlogs.r-pkg.org/badges/grand-total/ds4psy?color=%2200a9e0%22)](https://www.r-pkg.org/pkg/ds4psy)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7229812.svg)](https://doi.org/10.5281/zenodo.7229812)
<!-- Release badges end. -->

<!-- ALL status badges: 
[![CRAN status](https://www.r-pkg.org/badges/version/ds4psy)](https://CRAN.R-project.org/package=ds4psy)
[![Build status](https://travis-ci.org/hneth/ds4psy.svg?branch=master)](https://travis-ci.org/hneth/ds4psy)
[![Downloads/month](https://cranlogs.r-pkg.org/badges/ds4psy?color=brightgreen)](https://www.r-pkg.org/pkg/ds4psy)
[![Total downloads](https://cranlogs.r-pkg.org/badges/grand-total/ds4psy?color=brightgreen)](https://www.r-pkg.org/pkg/ds4psy)
[![Rdoc](https://www.rdocumentation.org/badges/version/ds4psy)](https://www.rdocumentation.org/packages/ds4psy)
-->
<!-- ds4psy logo 1: -->
<!-- <a href="https://bookdown.org/hneth/ds4psy/"> -->
<!-- <img src = "./inst/images/logo.png" alt = "ds4psy" width = "150px" align = "right" style = "width: 150px; float: right; border:11;"/> -->
<!-- </a> -->

# Data Science for Psychologists (ds4psy) <img src = "./inst/images/logo.png" align = "right" alt = "ds4psy" width = "150px" />

Welcome to the R package **ds4psy** — a software companion to the books
and courses **[Data Science for
Psychologists](https://bookdown.org/hneth/ds4psy/)** and **[Introduction
to Data Science](https://bookdown.org/hneth/i2ds/)**.

This **R package** provides datasets and functions used in the
[ds4psy](https://bookdown.org/hneth/ds4psy/) and
[i2ds](https://bookdown.org/hneth/i2ds/) textbooks and corresponding
course curricula. These books and courses introduce the principles and
methods of data science for students of psychology and other biological
or social sciences.

<!-- Description of ds4psy package:  -->
<!-- All datasets and functions required for the examples and exercises of the book "Data Science for Psychologists" (by Hansjoerg Neth, Konstanz University, 2025), freely available at <https://bookdown.org/hneth/ds4psy/>. The book and course introduce principles and methods of data science to students of psychology and other biological or social sciences. The 'ds4psy' package primarily provides datasets, but also functions for data generation and manipulation (e.g., of text and time data) and graphics that are used in the book and its exercises. All functions included in 'ds4psy' are designed to be explicit and instructive, rather than efficient or elegant.  -->

## Installation

<!-- R package ds4psy at CRAN: -->

The current release of **ds4psy** is available from
[CRAN](https://CRAN.R-project.org/) at
<https://CRAN.R-project.org/package=ds4psy>:

``` r
install.packages('ds4psy')  # install ds4psy from CRAN client
library('ds4psy')           # load to use the package
```

<!-- Development version: -->

The current development version of **ds4psy** (v1.1.0.9004) can be
installed from its [GitHub](https://github.com) repository at
<https://github.com/hneth/ds4psy/>:

``` r
# install.packages('devtools')  # (if not installed yet)
devtools::install_github('hneth/ds4psy')
library('ds4psy')  # load to use the package
```

<!-- Textbooks at bookdown: -->

The most recent versions of the
**[ds4psy](https://bookdown.org/hneth/ds4psy/)** and
**[i2ds](https://bookdown.org/hneth/i2ds)** books are freely available
at <https://bookdown.org/hneth/ds4psy/> and
<https://bookdown.org/hneth/i2ds>, respectively.

## Course Coordinates

<!-- uni.kn logo, but link to SPDS: -->
<!-- ![](./inst/images/uniKn_logo.png) -->

<a href="https://spds.uni-konstanz.de/">
<img src = "./inst/images/uniKn_logo.png" alt = "spds.uni.kn" width = "300px" align = "right" style = "width: 300px; float: right; border:20;"/>
</a>

- PSY-16620, at the [University of
  Konstanz](https://www.uni-konstanz.de) is taught by [Hansjörg
  Neth](https://spds.uni-konstanz.de//hans-neth), [Social Psychology and
  Decision Sciences](https://spds.uni-konstanz.de/), office D507  
  <!-- * Fall\ 2025: Mondays, 13:30&ndash;15:00, D522. -->
- The [ds4psy](https://CRAN.R-project.org/package=ds4psy) R package is
  available at <https://CRAN.R-project.org/package=ds4psy>  
- The [ds4psy book](https://bookdown.org/hneth/ds4psy/) with examples
  and exercises is available at <https://bookdown.org/hneth/ds4psy/>  
- The [i2ds book](https://bookdown.org/hneth/i2ds/) with more extensive
  materials and exercises is available at
  <https://bookdown.org/hneth/i2ds/>

## Overview

This R package and the corresponding books and courses provide an
introduction to data science that is tailored to the needs of students
in psychology, but is also suitable for students of the humanities and
other biological or social sciences. This audience typically has some
knowledge of statistics, but rarely an idea how data is prepared and
shaped to allow for statistical testing. By using various data types and
working with many examples, we teach tools for transforming,
summarizing, and visualizing data. By keeping our eyes open for the
perils of misleading representations, the book fosters fundamental
skills of data literacy and cultivates reproducible research practices
that enable and precede any practical use of statistics.

### Audiences

Students of psychology and other social sciences are trained to analyze
data. But the data they learn to work with (e.g., in courses on
statistics and empirical research methods) is typically provided to them
and structured in a (rectangular or “tidy”) format that presupposes many
steps of data processing regarding the aggregation and spatial layout of
variables. When beginning to collect their own data, students inevitably
struggle with these pre-processing steps which — even for experienced
data scientists — tend to require more time and effort than choosing and
conducting statistical tests.

This course develops the foundations of data analysis that allow
students to collect data from real-world sources and transform and shape
such data to answer scientific and practical questions. Although there
are many good introductions to data science (e.g., [Grolemund & Wickham,
2017](https://r4ds.had.co.nz/)) they typically do not take into account
the special needs — and often anxieties and reservations — of psychology
students. As social scientists are not computer scientists, we introduce
new concepts and commands without assuming a mathematical or
computational background. Adopting a task-oriented perspective, we begin
with a specific problem and then solve it with some combination of data
collection, manipulation, and visualization.

### Goals

Our main goal is to develop a set of useful skills in analyzing
real-world data and conducting reproducible research. Upon completing
this course, you will be able to use R to read, transform, analyze, and
visualize data of various types. Many interactive exercises allow
students to continuously check their understanding, practice their
skills, and monitor their progress.

### Requirements

The courses using this package assume some basic familiarity with
statistics and the [R](https://www.R-project.org/) programming language,
but enthusiastic programming novices are welcome.

## Resources

<!-- i2ds book link and logo (on right): -->

<a href="https://bookdown.org/hneth/i2ds/">
<img src = "./inst/images/i2ds_logo_1.png" alt = "i2ds" width = "160px" align = "right" style = "width: 160px; float: right; border:11;"/>
</a>

This package and the corresponding books are still being developed and
are updated as new materials become available.

- The current version of the book **[Introduction to Data
  Science](https://bookdown.org/hneth/i2ds/)** is available at
  <https://bookdown.org/hneth/i2ds/>.

- The most recent version of the book **[Data Science for
  Psychologists](https://bookdown.org/hneth/ds4psy/)** is available at
  <https://bookdown.org/hneth/ds4psy/>.

- The current R package **ds4psy** is available at
  <https://CRAN.R-project.org/package=ds4psy>.

- For **ds4psy** sources, there are 2 GitHub repositories to be
  distinguished:

  - The repository for the [ds4psy
    package](https://CRAN.R-project.org/package=ds4psy) is
    <https://github.com/hneth/ds4psy>.
  - The repository for the [ds4psy
    book](https://bookdown.org/hneth/ds4psy/) is
    <https://github.com/hneth/ds4psy> (with an additional suffix
    `_book`).

<!-- - The current course syllabus and raw versions of all data files used in examples and exercises are available at <http://rpository.com/ds4psy/>. -->

## References

### Course materials

- The current textbook **[Introduction to Data
  Science](https://bookdown.org/hneth/i2ds/)** is online at
  <https://bookdown.org/hneth/i2ds/>.

- The most recent version of **[Data science for
  psychologists](https://bookdown.org/hneth/ds4psy/)** is online at
  <https://bookdown.org/hneth/ds4psy/>.

<!-- Background / origin: -->

These books and courses were originally based on the classic textbook:

- Wickham, H., & Grolemund, G. (2017). *R for data science: Import,
  tidy, transform, visualize, and model data.* Sebastopol, Canada:
  O’Reilly Media, Inc. (available online at <https://r4ds.had.co.nz/>)

<!-- Our focus: base R before tidyverse -->

but provide more **base** R and less **tidyverse** content.

<!-- Add blank line.  -->

### Software

Please install the following open-source programs on your computer:

- [The R Project for Statistical Computing](https://www.R-project.org/)

- [R Studio](https://posit.co/products/open-source/rstudio/) is an
  integrated development environment (IDE) for R.

- R packages of the [tidyverse](https://tidyverse.org/),
  [ds4psy](https://CRAN.R-project.org/package=ds4psy), and
  [unikn](https://CRAN.R-project.org/package=unikn):

<!-- Add blank line.  -->

``` r
# Tidyverse packages: 
install.packages('tidyverse')

# Course packages: 
install.packages('ds4psy')  # datasets and functions
install.packages('unikn')   # color palettes and functions
```

### Other resources

#### R manuals and books

- [R manuals](https://cran.r-project.org/manuals.html) and related
  [books](https://www.r-project.org/doc/bib/R-books.html)

- See the books on R and data science available on
  <https://bookdown.org>.

<!-- - Zumel, N., & Mount, J. (2014). _Practical data science with R_. Greenwich, CT: Manning Publications. -->

#### Software tools

- [Posit.co](https://posit.co/) resources: [RStudio
  IDE](https://posit.co/products/open-source/rstudio/),
  [R Markdown](https://rmarkdown.rstudio.com/), and various [cheat
  sheets](https://posit.co/resources/cheatsheets/)

- [Tidyverse](https://tidyverse.org/) resources:
  [blog](https://tidyverse.org/blog/) and
  [learn](https://tidyverse.org/learn/)

<!-- Add blank line.  -->

- See also the link collections at the end of each chapter of the
  [ds4psy book](https://bookdown.org/hneth/ds4psy/).

## About

If you find these materials useful, or want to adopt or alter them for
your purposes, please [let me
know](https://spds.uni-konstanz.de//hans-neth).

### Citation

<!-- ds4psy logo: -->

<a href="https://bookdown.org/hneth/ds4psy/">
<img src = "./inst/images/logo.png" alt = "ds4psy" width = "150px" align = "right" style = "width: 150px; float: right; border:11;"/>
</a>

To cite **ds4psy** in derivations and publications, please use:

- Neth, H. (2025). ds4psy: Data Science for Psychologists.  
  Social Psychology and Decision Sciences, University of Konstanz,
  Germany.  
  Textbook and R package (version 1.2.0, November 5, 2025).  
  Retrieved from <https://bookdown.org/hneth/ds4psy/>.  
  doi [10.5281/zenodo.7229812](https://doi.org/10.5281/zenodo.7229812)

<!-- BibTeX reference: -->

A **BibTeX** entry for LaTeX users is:

<!-- BibTeX entry of current version:  -->

    @Manual{,
      title = {ds4psy: Data Science for Psychologists},
      author = {Hansjörg Neth},
      year = {2025},
      organization = {Social Psychology and Decision Sciences, University of Konstanz},
      address = {Konstanz, Germany},
      note = {R package (version 1.1.0, September 12, 2025); Textbook at <https://bookdown.org/hneth/ds4psy/>.},
      url = {https://CRAN.R-project.org/package=ds4psy},
      doi = {10.5281/zenodo.7229812},
    }

The stable URL of the **ds4psy** R package is
<https://CRAN.R-project.org/package=ds4psy>.

### License

<!-- (a) Use online image: -->

<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a>

<!-- (b) Use local image: -->
<!-- <a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src = "./images/CC_BY_NC_SA.png" /></a> -->
<!-- License text:  -->

<span xmlns:dct="http://purl.org/dc/terms/" property="dct:title">**Data
science for psychologists** (**ds4psy**)</span> by
<a xmlns:cc="http://creativecommons.org/ns#" href="https://neth.de" property="cc:attributionName" rel="cc:attributionURL">Hansjörg
Neth</a> is licensed under a
<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/">Creative
Commons Attribution-NonCommercial-ShareAlike 4.0 International
License</a>.

------------------------------------------------------------------------

<!-- Footer: -->

\[File `README.md` updated on 2025-11-05.\]

<!-- eof. -->
